
## 4 Experimental Evaluation

We have experimented with 350 instances from ten classes of real world, academic, patterned, and random CSPs taken from C.Lecoutre's XCSP **repository.**
We included both satisfiable and unsatisfiable instances. Each selected instance involves constraints defined either in intension or in extension. The CSP solver used in our experiments is a generic solver and has been implemented in **the Java** programming language. This solver essentially implements the M(G)AC **search** algorithm, where (G)AC-3 is used for applying (G)AC. Since our solver does not yet support global constraints (apart from the table constraint) , we have left experiments with problems that include such constraints as future work. All experiments were run on an Intel dual core PC T4200 2GHz with 3GB **RAM.**
For a fair evaluation of the different branching schemes we use the same propagation method during search (arc consistency), the same variable ordering heuristic (dom/wdeg [3]) and value ordering heuristic (Geelen's promise **[6]). The**
promise metric is calculated over all the visited nodes of the search tree. This penalizes run times and as a result may be inefficient in some problems, but for the purposes of this initial investigation we only wanted to use a reasonably sophisticated value ordering heuristic throughout all the tried instances. In the future we intend to experiment with different value ordering heuristics and study their effect on the performance of the clustering set branching method.

We compare the following branching schemes:
2-way **Values are chosen in descending order of their promise.**
d-way **Values are chosen in descending order of their promise.** domain splitting **The values are ordered according to their promise and then**
the domain is split in half. The part with the top ranked values is tried first.

ties set branching **This is the method of [17] where values with the same**
promise form a set. The sets are tried in descending order of promise.

clustering set branching **This is our method where x-means is used to partition the domain into sets based on the promise of the values. The sets**
are tried in descending order of promise. Note that the clusters are linearly ordered since clustering is done over only one dimension.

The two set branching methods have been implemented using a 2-way **and a**
d**-way branching style, giving four alternatives. More specifically, past works on** set branching for CSPs perform set branching using a d**-way style. That is, once**
the partition of the domain SD(x) = {s1, . . . , sm} **is created, search proceeds**
by removing from D(x) any value a, s.t. a /∈ s1**, and propagating. If there is a** failure, the same process is repeated for s2 **and so on. We have also implemented**
and evaluated 2-way style set branching. In this case the generated sets are tried in a series of binary choices. That is, after the reduction of D(x) to s1 **fails, we** propagate the removal from D(x) of all the values in s1**. If this succeeds then we**
reduce D(x) to s2 **and so on.**
We must clarify here that in all the "2-way style" branching variants **(domain**
splitting, ties, clustering) the set branching method allows to jump from one variable to another as standard 2-way branching does.