# The Challenge Of Believability In Video Games: Definitions, Agents' Models And Imitation Learning

Fabien Tenc´e
∗
,∗∗**, C´edric Buche**
∗
**, Pierre De Loor**
∗ **and Olivier Marc**∗∗
∗ **UEB - ENIB - LISyC**
∗∗ **Virtualys**
Brest - France
{tence,buche,deloor}**@enib.fr**

## Abstract

In this paper, we address the problem of creating believable agents (virtual characters) in video games. We consider only one meaning of believability, "giving the feeling of being controlled by a player", and outline the problem of its evaluation. We present several models for agents in games which can produce believable behaviours, both from industry and research. For high level of believability, learning and especially imitation learning seems to be the way to go. We make a quick overview of different approaches to make video games' agents learn from players. To conclude we propose a two-step method to develop new models for believable agents. First we must find the criteria for believability for our application and define an evaluation method.

Then the model and the learning algorithm can be designed.

## Keywords

Adaptive decision making, believability, human-like, evaluation, imitation learning, video games.

## Introduction

Nowadays, more and more consoles and video games are designed to make the player feel like he/she is in the game. To define how well this goal is achieved, two criteria have been defined in academic research: immersion and presence**. According to Slater, immersion is an**
objective criterion which depends on the hardware and software (Slater et al. 1995). It includes criteria based on virtual sensory information's types, variety, richness, direction and in which extend they override real ones. For example, force feedback and motion sensing controllers, surround sound and high dynamic range rendering can improve the immersion. Presence, also known as telepresence (Steuer 1992), is a more subjective criterion. It is defined as the psychological sense of "being there" in the environment. It is mainly influenced by the content of the video game.

As stated in (Slater et al. 1995), presence partly depends on the match between sensory data and internal representation. This match expresses the fact that we try to use world models to better understand what we perceive and to be able to anticipate (Held and Durlach 1991). This idea is close to what is called believability **in the arts. Indeed, we can believe in fictional objects, places, characters and story only if they mostly fit**
in our models. Enhancing believability of video games' content should then enhance the presence.

As there are many ways to enhance believability in video games, we choose to focus on believable virtual characters, also known as believable agents. The reason why we make this choice is because characters have often a major role in the believability of book and movie stories. However, unlike book and movie characters, agents should be able to cope with a wide range of possible situations without anyone to tell them what to do. Instead of defining manually these behavior, it can be interesting for the agents to learn them, reducing the time to design a character. The ability to learn has also the advantage of increasing believability so it should be considered as a must-be feature.

The goal of this paper is to have an overview of the possibilities and constraints for the realization of a believable and learning-capable agent in a video game. We first define what are believable agents in games, how we can evaluate them and the relations between believability and the type of video games. Then, we make a quick overview of how an agent can express believable behaviors and how it can learn them. Finally, we conclude on a two-step protocol to realize believable agents.

## Believability Definition Of Believability

The notion of believability is highly complex and subjective. To define and understand this concept, we must look at its meaning in the arts where it is a factor of suspension of disbelief **(Bates 1992). According to Thomas**
and Johnston, two core animators of Disney, believable characters' goal is to provide the illusion of life **(Thomas**
and Johnston 1981). Reidl's definition is more precise: