"**Character believability refers to the numerous elements** that allow a character to achieve the 'illusion of life',
including but not limited to personality, emotion, intentionality, and physiology and physiological movement"
(Riedl and Young 2005, page 2). Loyall tries to be more objective saying that such a character "**provides a convincing portrayal of the personality they [the spectators]**
expect or come to expect**" (Loyall 1997, page 1). This** definition is quite close to one factor of the presence, the match between players' world model and sensory data.

If we want to apply the believability definition for video games, things become even more complex. Unlike classic arts, players can be embodied in a game by the mean of virtual bodies and can interact. The believability question is now: does a believable character have to give the illusion of life or have to give the illusion that they are controlled by a player? (Livingstone 2006). There can be very important differences as even if the video game depicts the real world, all is virtual and players know that their acts have no real consequence.

In this paper, we will consider only believable as "giving the illusion of being controlled by a player". At first glance, it can be seen as going against presence as we remind the players that there is a real world. However, not using this approach has some drawbacks too: virtual characters only giving the illusion of life can be classified as "being a piece of program" which may break the illusion permanently. Players may also see problems in the virtual characters' behavior only because they know they are not human-controlled.

Now that we chose a definition for believability, we have to find the different criteria that influence it. Defining those criteria will make improvements and evaluation possible.

## Believability Criteria

Criteria to define believability are highly domaindependant. For example, for embodied conversational agents (ECA), factors like quality of the speech, facial expressions, gestures are important (Ruttkay et al. 2002). For emotional and social agents, reaction to others is the most important part (Reilly 1996) and so on with the numerous domain working on believable agents. However, there is one criteria that can be used for every domains. What have been named Eliza effect (Weizenbaum 1966) is really interesting: as long as the agent is not actively destroying the illusion, people tend to see complex thinking mechanisms where there are not.

One way to destroy the illusion is predictability, which is a classic flaw for characters in video games. Characters doing over and over the exact same thing are rapidly categorized as being artificial. Adding some unpredictability can better a lot believability (Bryant and Miikkulainen 2006). The difficulty is that too much unpredictability can give the feeling of randomness which can harm believability too. Another flaw is obvious failure to learn. An agent keeping the same behavior even if it is clearly counter-productive breaks the illusion of being "intelligent". That is the main reason why we think that believable agents must be able to learn (Gorman and Humphrys 2007).

The last criterion we will cite makes the difference between believability and realism. Unlike realistic agents, believable agents might be forced to overdo for observers to understand what they are doing (Pinchbeck 2008).

Although it can seem strange, it is sometimes mandatory to exaggerate some of the agent's characteristics so that people believe in it. This technique is very often used in arts, especially in cartoons. This means that human-like agents could have a quite low believability.

There are however links between realism and believability so it should be a good start to draw inspiration from realism.

Knowing what influence believability, we can design an evaluation method for believable agents. As the cited criteria are quite general, more domain-specific ones should be taken into account in the evaluation.

## Evaluation Of Believability

As believability is subjective, evaluation is a critical and complex step. Even if it was not intended to, Turing's test (Turing 1950) is still considered as a reference for believability evaluation. In its standard interpretation, a judge must chat with a human and a machine using only text. If, after a certain amount of time, the judge cannot tell which one is artificial, the machine is said to be intelligent. This test's goal was to assess intelligence but it has been much criticized
(Searle 1980; Hayes and Ford 1995). This critique, however, does not apply to believability and it is even a very good basis for assessing believability as we defined earlier.

There are many parameters for believability evaluation methods (Mac Namee 2004; Gorman et al. 2006; Livingstone 2006). The first one is to cast or not to cast doubt on the nature of the presented character(s). This choice is often linked with mixing agents and humans so that the judges assess real humans' believability too. This can be useful to avoid bias induced by prejudices and to have a reference: humans usually do not score a perfect believability. Another parameter is the number of questions and answers. Turing's test features only one