question and a yes/no answer whereas other tests feature many questions and scales to answer. The former choice may be too restrictive while the latter may result in too much undecided answer to "beat" the test. Another problem is the computation of the overall believability score which, in case of multiple questions, may give experimenters too much influence on the results. To add more objectivity, it is possible to have relative scoring instead of absolute: the score given to a example can answer to "is example A better than example B?". It is also necessary to decide if judges are players or only spectators. While players can actively test evaluated characters, spectators are more focused on them and can notice much more details in the behaviors. Finally the choice of the judges is really important. Cultural origins (Mac Namee 2004) and level of experience
(Bossard et al. 2009) may have a noticeable impact on believability scores.

## Links Between Believability And Video Games

Following our definition of believability, multiple players should be able to play together in the same video game. Indeed, players must not know a priori **if what** they perceive is due to another player or to a program. Believable agents should be used to replace a missing player, having the same role as the others so that we can achieve high level of believability. Of course, single player games can achieve human-like agents but they will not be believable as we defined it.

The video games' complexity of interactions has a really important impact on the believability. If interactions between the players, agents and the game are few, it may be hard to assess believability. For example in a pong game, players can only move paddles so it may be difficult for them to guess the thoughts of the adversary.

On the contrary, if players and agents have a wide range of possible actions, they can better perceive the others' thoughts making believability harder to achieve. Video games featuring a complex world and allowing a lot of interactions should be preferred to develop and evaluate believable agents.

Video games are often categorized in different groups.

For a testbed, we need a multiplayer game with a lot of possible interactions between players. This kind of games can be found in the action, role playing, adventure and sport games categories. From a technical point of view, adventure and sport games tend to be difficult to modify and in particular to add agents. Role playing involves a large part of communication and natural language is far too much complex to make conversational agents truly believable. Action games are often good choice because they have a quite limited set of actions, simplifying the learning, but their combination are complex enough to be a challenging problem for believability.

The classical example of such action games is first person shooter games. In those games, each player or agent controls a unique virtual body and sees through its eyes. The character can, non-thoroughly , grab items (weapons, . . . ), move (walk, jump, . . . ) and shoot with a weapon. Each character has an amount of hit points, also known as life points: each time an actor is hit by an enemy fire, a certain amount of hit points are subtracted to the current value. When hit points reach zero, the character "dies" but can usually reappear at another place in the game's environment. Although the concept can seem very basic, it can prove challenging to design believable agents. To make things simpler at the beginning, it is possible to avoid cooperative rules as tactics used may be quite hard to learn.

## Agents' Behaviour Modelling

The general principle of an agent is to perceive its surroundings, take some decisions according to those perceptions and its internal state and then make some actions which depend on the decisions. This is named the perception, decision, action loop because the sequence is repeated over and over. The sets of actions and perceptions are defined by the video game so designing an agent is "only" to find a good mapping between perceptions and actions.

The general structure of the agents' thinking mechanisms is called a model. The model, when parametrized, generates behaviors: it gives a sequence of actions when fed with a sequence of perceptions. In other words, the model is the way to express behavior and the parameters are the behavior.

There are many different agents' behavior models and some can achieve better believability than others. Three domains are very influential on their design: computer sciences, psychology and neurosciences. Computer sciences see agents' models as programs, with inputs and outputs and composed of mathematical functions, loops, etc. Models influenced by psychology try to apply what science understood about humans' behaviors. Finally, models based on neurosciences try to code an artificial brain composed of neurons grouped in different specialized zones. There are many hybrid models and even some of them combines all the three.

There are also two different approaches in the way the agents think: reactive or deliberative. Reactive agents map directly actions to perceptions. The problem is that they tend not to act with long term objectives.

Deliberative agents, on the other hand, try to predict