the results of their actions. They make plans so that the sequence of their actions will satisfy their needs. Their main weakness is that they are often not very good in rapidly changing environments. Some agents combine reactive and deliberative abilities to have both advantages without the weaknesses.

## Models In Industry

In the video game industry, models are often quite basic but can achieve good believability in the hands of skilled game designers. Finite state machines (FSM),
hierarchical FSM and behaviors trees are widely used. Those models can express logic, basic planning and are good at reactive behaviours. Another advantage is that those models are deterministic, in other words we can predict what can happen and then try to avoid problems. Their major weakness is that their expressiveness is limited and explaining complex behaviors can become unmanageable.

Another type of model which is used in video game industry is planners. They can give very good results in terms of believability, an example is the game F.E.A.R. which is partially based on the STRIPS planner (Fikes and Nilsson 1971). Agents featuring planners are able to set up complex tactics which have an important impact on believability. However they are not yet capable of learning so they can become predictable. Other models are, by less, used in video games.

## Models In Research

In scientific research, many different models are used for agents. Some of the main architectures are Soar
(Newell et al. 1987), ACT-R (Anderson 1993) and BDI (Rao and Georgeff 1995). However, these models are not design for believability but for reproducing some humans' thinking mechanisms. Some models are, from the beginning, designed for believability like those used in (Lester and Stone 1997; Mac Namee 2004) and in the Oz project (Bates 1992; Reilly 1996; Loyall 1997) but they are not suited for action games but for emotions and social interactions.

For action games, some work has been done and different models have been presented. (Le Hy et al. 2004) is a Bayesian model which seems to produce quite believable behaviors but lacks of long-term goals. (Robert and Guillot 2005) is a model using classifiers with a online unsupervised learning algorithm but the agents' believability has not been evaluated. (Gorman et al. 2006) use Bayesian imitation, partly based on (Rao et al. 2004),
and have a good believability. However it only produces a part of the whole behavior needed for the game.

(Gorman and Humphrys 2007) is "only" based on neural networks but due to its learning algorithm, it gives really good results in terms of believability. Here too, it produces only a part of the behavior.

A good choice seems to have an hybrid reactivedeliberative agent as planning has a great impact on believability so as reactivity (Laird and Duchi 2000). Contrary to what is commonly used in video games, a non-deterministic approach is preferable because it can increase believability by avoiding repetitiveness. Agents must be able to learn and, in the best case scenario, should need minimal a priori **knowledge. This implies**
that the model does not need to be easily understandable and adjustable as most of its knowledge could come from learning.

## Actions And Perceptions

The choice of the model's inputs and outputs is very important because it has a great influence on the final result. What seems logical is to have the exact same sets for the agents and for the players so that agents have all the necessary tools to be believable. However, the perceptions and actions information follow a complicated process between the players' brain and the game.

Moreover, having human-like interaction can make the problem even more complicated and instead of improving believability, it could make it worse.

The perception information begins in the video game, each object in it having a set of characteristics like position, rotation, color or texture. All those objects are rendered so they are a sequence of pixel. Those pixels are displayed by a peripheral like a screen or a video projector. Then the information go to our eye and then to our brain. We use visual information as an example, it is also true with sounds, touch and will be true for odors and tastes in the future.

As we can see, the perception information takes multiple forms and all may not be usable or useful for believable agents. From the moment the game's environment is rendered, we enter the domain of artificial vision, audition, etc. Unfortunately, this is a very difficult problem and very few information can be obtained this way. As a consequence, there is a great loss of available information when the rendering is done. The best compromise is to use information directly from the game. It results in having both very precise information, like position, and unavailable information, like lighting.

For the actions, they begin in our brain, then muscles, go through the game's peripherals and arrive in the game. It is possible to simulate peripherals' activity, however it has some drawbacks too. Peripheral information are very low-level so we must translate high-level