goals to low-level sequences. If the agent wants to go to some place, it has to find a sequence of peripheral-like actions instead of defining a trajectory for its virtual body.

## Learning By Imitation Why Imitation?

Form the beginning, we have discussed only about learning without specifying the "how". The reason we choose to focus on imitation only is because of believability. As we defined it, believability means "to look like a player". One efficient way to achieve this is to copy or imitate him/her (Schaal 1999).

## Definition And Approaches

Imitation has quite a pejorative connotation as the
"innovate, don't imitate" sentence shows. It is however a clever way of learning and very few animals can use it (Blackmore 1999). Moreover, humans use it very often, such often that they do not always notice it and they do it from the very beginning of their lives (Meltzoff and Moore 1977). Imitation is the act of observing a certain behavior and roughly repeating it. This repetition can be deferred and the demonstrator may or may not be aware of being imitated.

From a behavioral and cognitive sciences approach, imitation is the increased tendency to execute a previously demonstrated behavior. The imitated behavior must be new to the imitator and the task goal should be the same as the demonstrator (Schaal 1999). There are some debates on whether or not the strategy should be the same. According to Meltzoff, inferring intentions is necessary for higher level imitation where imitators learn the goals instead of the strategy to achieve them
(Rao et al. 2004). This can lead to unsuccessful attempts being use as examples in imitation learning as long as the goal can be inferred. It this case, the strategy may be different from the example given by the demonstrator. From a neuroscience approach, imitation can be explained studying the brains of evolved animals. Some areas are hypothesized to be involved in imitation learning according to studies on macaques' brains. The quite recent discovery of mirror neurons **may help in understanding the mechanisms of imitation. Mirror neurons**
are neurons that fire both when we do something and when we look at someone doing the same thing. However it is not sure that they actually have a major role in the imitation process.

In the domains of robotics and artificial intelligence, imitation learning becomes more and more popular. It has been particularly used in movements imitation in robotics because it reduce the programming time of humanoids robots (Gaussier et al. 1998). Indeed, when we explain a movement to somebody else, showing the example is far more productive than explaining only with words. The same goes with robots and agents: imitation reduce the space of hypothesis the program has to search.

## Imitation Learning In Computer Sciences

The main reason we chose imitation learning is that believability is quite linked with resembling to the demonstrator, in our case humans. According to some authors, imitation can lead to believable or at least humanoid agents and robots (Schaal 1999; Thurau et al. 2005). This learning technique seems to be both fast and adequate for our goal.

An interesting model and learning algorithm based on imitation has been designed by Rao and Meltzoff
(Rao et al. 2004). What makes it particularly interesting is that it is based on Meltzoff's work on imitation in infants. The model uses probabilities to determine which actions should be taken according to the perceptions. Those probabilities are learnt observing a player's virtual body. Another interesting characteristic is that the agent can guess the player's goals to better understand his/her behavior. This model and algorithm have been extended and used in a action game (Gorman et al. 2006) leading to interesting results.

Some work focused more on the imitation of movement in games which is often highly reactive and strategic at the same time. In their work, Thurau et al. **used**
an algorithm named neural gas to represent the geometry of the game's environment (Thurau et al. 2004).

They then use an algorithm to learn potential for each neuron/waypoint by giving path followed by players. The sum of those potentials form a field force, attracting the agent to interesting places.

Another interesting work does not use a new model or a new algorithm (Gorman and Humphrys 2007) and it only covers one behavioral aspect: aiming and shooting in an action game. The model consists of three neural networks, one for choosing a weapon, one for aiming and one to choose to fire or not. Those neural networks are trained with a Levenberg-Marquardt algorithm on players' data previously gathered and treated. The results are very encouraging as the agents were capable of short-term anticipation and acted in a really human-like fashion. Agents even copied behaviors due to the use of a mouse: right-handed players have more difficulties to