follow targets travelling from the right to the left with their cursor.

One last work based on imitation learning which seems to give very good results is (Le Hy et al. 2004). For basic motion control it use the rule of succession to find probabilities of action by counting the number of occurrences. This rule's main interest is that it estimates the probabilities of actions that did not occur.

For the linking of the tasks to achieve, as the model is close to a hidden markov model (HMM), an incremental Baum-Welch algorithm is used to find the parameters. This algorithm permits online learning so it may prove to be a great tool for believability. The main drawback is that we must find a way to identify the current task so that corresponding parameters can be modified.

## Learning Constrains

As we said earlier, obvious failure to learn can break the illusion of life. Our first constraint is that the learning process can be observable. This implies that the agent can learn while playing and that it learns fast. The first implication is named online learning **in terms of artificial intelligence. It means that the model is modified**
for each given example. It contrasts with offline learning **where the model is only modified when all examples**
are given.

Despite the fact that imitation learning can be a fast way to learn, this goal is not easy to achieve. The difficulty in imitation learning is generalization: we do not want the agent to be a film of what the demonstrator showed but to adapt to the environment as the demonstrator did. Learning systems often need examples and counter-examples to learn to avoid over-generalization and over-learning. In imitation learning we only have examples so we might need many of these for the agent to understand how to generalize. This can slow down a lot the learning.

As we saw earlier, learning algorithms and agents' models are heavily linked together. Indeed, the process of learning consists in modifying the model's parameters. The algorithm can even modify the structure of the model. The choice of the learning algorithm or its design cannot be done without choosing or knowing the behavioral model. This makes this choice even more complicated as we must consider the pros and the cons for the couple and not for each one separately.

## Conclusion

In this paper we outlined the problem of creating believable agents in video games. This problem has three parameters: the players, the video game and the agents.

We can add on top the learning mechanisms to make agents capable of evolution. All those factors have an important impact on the final result so their influence should be carefully studied.

First, believability is a very complex notion because of its subjectivity. We defined it as the "illusion that the agent is controlled by a player". Although this definition is quite different from the one used in arts, it makes sense in video games. Indeed, several people can interact in the same game and replacing some of them by computer programs can be very interesting. What makes believability complex is that although players have difficulties in understanding the others' behaviors and often interpret them wrongly, some small flaws can destroy the whole illusion.

The next important factor is the video game itself.

A believable agent in an game where it is only possible to chat will be very different from a believable agent in an game where it is only possible to move. Complex games which require both reactive and planning abilities as well as featuring a wide range of possible interactions between players are the most challenging testbeds for researchers.

The agent itself and more precisely the model defining its behaviors is the most obvious factor in the problem. Models can express more or less believable behaviors depending on how they model human characteristics. So, although there are many models both in the industry and the research, they are not all suitable for believable agents.

An agent will not be able to make the illusion last very long if it is not capable of evolving. One possible way of evolution is learning. Imitation learning seems to fit perfectly with the goal of believability. Indeed, it consists in copying the demonstrator acts which is quite close to the notion of believability. It is also a very fast method for transmitting knowledge from one person to another.

The first step in the design of a believable agent is to define an evaluation method. This will help us in knowing which characteristics are important for our agent.

This cannot be done without choosing a video game first because the notion of believability depends on the agent's set of actions. It can be also very interesting to evaluate humans' and simple agents' believability first to better understand the problem.

The next step is to choose or design a behavioral model and an imitation learning algorithm. This should be done according to the believability factors discovered in the previous step. Considering the constrains of fast