# Automatable Evaluation Method Oriented Toward Behaviour Believability For Video Games

Fabien Tenc´e
∗
,∗∗ **and C´edric Buche**
∗

∗ **Universit´e Europ´eenne de Bretagne - ENIB**
LISyC - CERV
25, rue Claude Chappe 29280 Plouzan´e (France)
∗∗ **Virtualys**
41 rue Yves Collet 29200 Brest (France) {tence,buche}**@enib.fr**

## Keywords

Artificial intelligence, agent evaluation, believable behaviour, human tracking

## Abstract

Classic evaluation methods of believable agents are time-consuming because they involve many human to judge agents. They are well suited to validate work on new believable behaviours models. However, during the implementation, numerous experiments can help to improve agents' believability. We propose a method which aim at assessing how much an agent's behaviour looks like humans' behaviours. By representing behaviours with vectors, we can store data computed for humans and then evaluate as many agents as needed without further need of humans. We present a test experiment which shows that even a simple evaluation following our method can reveal differences between quite believable agents and humans. This method seems promising although, as shown in our experiment, results' analysis can be difficult.

## Introduction

The vast majority of video games features computer controlled virtual characters, also known as agents, to enrich their environment. For games to be able to suspend disbelief (Bates 1992), those agents should be believable**. However, this term have two distinct meanings:**
first, the ability to be a good role-player and second, the ability to be indistinguishable from a human player
(Livingstone 2006). We aim at agents taking on the role of players, so we will use the latter definition in this paper.

When modelling or implementing an agent's behaviour, an important step is evaluation. It can be very useful to improve the final result by tuning the model's parameters or by modifying the model itself. Evaluation is almost mandatory to validate work and should be able to answer: to what extent does the agent meet the objectives? or is it better than what have been done before? However, evaluation of believable agents is rather difficult because believability is based on the observers' feelings. Many studies deal with this problem like (Mac Namee 2004; Livingstone 2006; Gorman et al. 2006). However, they still rely on humans to judges agents. As a result, this kind of method cannot be used to evaluate a large number of different behaviours. Moreover, the use of questionnaires for evaluation is criticised (Slater 2004).

Knowing these problems, we propose a method using a different approach: we aim at reducing human intervention as much as possible still helping researchers assessing artificial behaviours' believability. The objective is to have a method which could be automatised and thus which can be used in optimisation algorithms or for tests during the night. For this, we chose to measure artificial behaviours' likeness to human behaviours, a concept close to believability. Of course, this method does not aim at replacing classic ones but rather offers a complementary approach so that the final result looks more believable.

## Evaluation Method Proposition Principle

The evaluation's general principle is to compute vectors which are features of humans' and agents' behaviours. We call those vectors "signatures" as they should be designed to be representative of a behaviour. By measuring the distance between an agent's signature and humans', it should be possible to tell if its behaviour looks like a human behaviour or not.

arXiv:1009.0501v1 [cs.AI] 2 Sep 2010