
## Protocol

Here are the main stages of the protocol to evaluate an agent with respect to humans:

1. Define behaviour signatures and metrics between them; 2. Monitor humans (the more the better) and compute the signatures; 3. Monitor the agent to be evaluated and compute the signatures in the same conditions as the monitored humans; 4. Compute the distance between each agent's signature and its human equivalent.
The first part is very challenging because we need to find signatures having a low variance for humans, still being able to detect non-believable behaviours. This could be a problem when humans are given a great freedom because their behaviour can vary widely. To determine good signatures, it can be necessary to run the protocol several times with few humans and to modify signatures and/or metrics so that they have nice properties.

For the second and the third steps, human and agents must be studied under the same conditions. Since agents do not play against humans, if virtual characters coexist in the same environment we have to make a concession: for the step 2, humans are together and for the step 3, agents are together. If we introduce agents in step 2, signatures could be flawed by reflecting interaction between humans and non-believable agents.

We presented our method as been automatable. Indeed, step 3 and 4 can be redone without further need of humans. However, automatable does not mean fast as step 3 can take some time. To determine the experiment's duration, a study should be done in order to test how much time the signatures need to stabilise.

## Monitoring Agents And Humans

As explained in the protocol, we must monitor both humans and agents so that we can compute signatures.

To be totally independent from the internal architecture, we chose to take the same point of view as a judge looking over the subject's shoulder. Therefore, in the well-known perception-decision-action loop we can only have access to the actions and the perceptions. We assume that the loop can be observed for human as well so that we can compare agents' and humans' perceptions and actions in the same manner.

The principle of the monitoring is to keep track of a subset of these perceptions and actions during simulations so as to build the signatures. For example, in a first person shooter, we could track basic actions and perceptions such as if the actor is jumping and if it sees an enemy. It could then be possible to build a very simple signature measuring the proportion of jumps when an enemy is visible.

There are three main kind of signatures: perceptionbased, action-based and those linking actions to perceptions. Perception-based signatures are not very useful because players judges agents on their actions. Actionbased can be useful but may be too simple to explain complex behaviours. Finally, signatures linking actions to perceptions are the most interesting ones because they may find patterns in the decisions. However, there is a difficulty: if an information is monitored in perceptions, it is not sure that the agent or the human noticed this information.

## Experiment

For the experiment, we used the game Unreal Tournament 2004. It is a first person shooter game, in other words each player or agent controls a unique virtual character and sees through its eyes. The character can, non-thoroughly , grab items (weapons, . . . ), move (walk, jump, . . . ) and shoot with a weapon. Each character have an amount of hit points, also known as life points:
each time an actor is hit by an enemy fire, a certain amount of hit points are subtracted to the current value. When hit points reaches zero, the character "dies" but can usually reappear at another place in the virtual environment. Although the concept can seem very basic, it can prove challenging for agents to mimic humans.

This experiment's main objective is to give a concrete example and to show the interest of the method. Therefore, the signatures are simple and would be insufficient for a real evaluation. Moreover, for the sake of simplicity, this sample experiment try to assess only the believability of Unreal Tournament 2004 agents' movements.

Here are the signatures:

- **Velocity change angle: 20-dimensions vector, the**
value of the i**-th component is the number of time**
we measured an angle of approximatively i **between**
−→V t and −→V t+1**. Note that the vector as only 20 components so an angle of 20 corresponds to a whole**
turn, 10, half turn, etc. This vector is then normalised.

- **Velocity relative to the direction: 20-dimensions**
vector, the value of the i-th component is the number of time we measured an angle of approximatively i between −→V t and −→Dt. The same unit as the