
## 1 Introduction

Levesque's notion of only-knowing is a single agent monotonic logic that was proposed with the intention of capturing certain types of nonmonotonic reasoning. Levesque ([1990]) already showed that there is a close connection to Moore's ([1985]) autoepistemic logic (AEL). Recently, Lakemeyer and Levesque ([2005]) showed that only-knowing can be adapted to capture default logic as well.

The main benefit of using Levesque's logic is that, via simple semantic arguments, nonmonotonic conclusions can be reached without the use of meta-logical notions such as fixpoints [Rosati 2000; Levesque & Lakemeyer 2001] . Only-knowing is then naturally of interest in a many agent context, since agents capable of non-trivial nonmonotonic behavior should believe other agents to also be equipped with nonmonotonic mechanisms. For instance, if all that Bob knows is that Tweety is a bird and a default that birds typically fly, then Alice, if she knows all that Bob knows, concludes that Bob believes Tweety can fly.1 Also, the idea of only-knowing a collection of sentences is useful for modeling the beliefs of a knowledge base (KB), since sentences that are not logically entailed by the KB are taken to be precisely those not believed. If many agents are involved, and suppose Alice has some beliefs on Bob's KB, then she could capitalize on Bob's knowledge to collaborate on tasks, or plan a strategy against him.

As a logic, Levesque's construction is unique in the sense that in addition to a classical epistemic operator for belief, he introduces a modality to denote what is *at most* known. This new modality has a subtle relationship to the belief operator that makes extensions to a many agent case non-trivial.

Most extensions so far make use of arbitrary Kripke structures, that already unwittingly discard the simplicity of Levesque's semantics. They also have some undesirable properties, perhaps invoking some caution in their usage. For instance, in a canonical model (Lakemeyer 1993), certain types of epistemic states cannot be constructed. In another Kripke approach (Halpern 1993), the modalities do not seem to interact in an intuitive manner. Although an approach by Halpern and Lakemeyer ([2001])
does indeed successfully model multi-agent only-knowing, it forces us to have the semantic notion of validity directly in the language and has proof-theoretic constructs in the semantics via maximally consistent sets. Precisely for this reason, that proposal is not natural, and it is matched with a proof theory that has a set of new axioms to deal with these new notions. It is also not clear how one can extend their semantics to the first-order case. Lastly, an approach by Waaler ([2004]) avoids such an axiomatization of validity, but the model theory also has problems [Waaler & Solhaug 2005]. Technical discussions on their semantics are deferred to later.

The goal of this paper is to show that there is indeed a natural semantics for multi-agent onlyknowing for the quantified language with equality. For the propositional subset, there is also a sound and complete axiomatization that faithfully generalizes Levesque's proof theory.2 We also differ from Halpern and Lakemeyer in that we do not enrich the language any more than necessary (modal operators for each agent), and we do not make use of canonical Kripke models. And while canonical models, in general, are only workable semantically and can not be used in practice, our proposal has a computational appeal to it. We also show that if we do enrich the language with a modal operator for *validity*,
but only to establish a common language with [Halpern & Lakemeyer 2001], then we agree on the set of valid sentences. Finally, we obtain a first-order multi-agent generalization of AEL, defined solely using notions of classical logical entailment and theoremhood.

1