Many people treat data mining as a synonym for another popularly used term, Knowledge Discovery in Databases, or KDD [2]. Alternatively, data mining is also treated simply as an essential step in the process of knowledge discovery in databases. The fast-growing, tremendous amount of data, collected and stored in large and numerous databases, has far exceeded our human ability for comprehension without powerful tools [4]. In such situation we become data rich but information poor. Consequently. Important decisions are often made based not on the information-rich data stored in databases but rather on a decision maker's intuition, simply because the decision maker does not have the tools to extract the valuable knowledge embedded in the vast amounts of data. In addition, current expert system technologies rely on users or domain experts to manually input knowledge into knowledge bases [5]. Unfortunately, this procedure is prone to biases and errors, and is extremely time consuming and costly. In such situation data mining tools can perform data analysis and may uncover important data patterns, contributing greatly to business strategies, knowledge bases, and scientific or medical research. 

## 2.2 Association Rule

 Association rule mining finds interesting association or correlation relationships among a large set of data items. In short association rule is based on associated relationships. The discovery of interesting association relationships among huge amounts of transaction records can help in many decision-making processes. Association rules are generated on the basis of two important terms namely minimum support threshold and minimum confidence threshold. 

Let us consider the following assumptions to represent the association rule in terms of mathematical representation, J = {i1, i2, . . . , im} be a set of items. Let D the task relevant data, be a set of database transactions where each transaction T is a set of items such that T J. Each transaction is associated with an identifier, called TID. Let A be a set of items. A transaction T is said to contain A if and only if A T. An association rule is an implication of the form A B, where A J, B J, and A∩B = Φ. The rule A B holds in the transaction set D with support s, where s is the percentage of transactions in D that contain A B (i.e. both A and B). This is taken to be the probability, P (A B). The rule A B has confidence c in the transaction set d if c is the percentage of transaction in D containing A that also contain B. This is taken to be the conditional probability, P (B | A). That is, 

## Support (A B) = P (A B) And Confidence (A B) = P (B | A)

Association Rules that satisfy both a minimum support threshold and minimum confidence threshold are called strong association rules. A set of items is referred to as an itemset. In data mining research literature, "itemset" is more commonly used than "item set". An itemset that contains k items is a k-itemset. The occurrence frequency of an itemset is the number of transactions that contain the itemset. This is also known, simply as the frequency, support count, or count of the itemset. An itemset satisfies minimum support if the occurrence frequency of the itemset is greater than or equal to the product of minimum support and the total number of transactions in D. The number of transactions required for the itemset to satisfy minimum support is therefore referred to as the minimum support count. If an itemset satisfies minimum support, then it is a frequent itemset. The set of frequent k-itemsets is commonly denoted by Lk. Association rule mining is a two-step process, which includes: 
1. Find all Frequent Itemsets 2. Generate Strong Association Rules from the Frequent Itemsets 