
## 2.3 The Apriori Algorithm

 Apriori is an influential algorithm for mining frequent itemsets for Boolean association rules [1] . The name of the algorithm is based on the fact that the algorithm uses prior knowledge of frequent itemset properties. Association rule mining is a two steps process [7]. 

i) Find all frequent itemsets: By definition, each of these itemsets will occur at least as frequently as a predefined minimum support count. 

ii) Generate strong Association rules from the frequent itemsets: By definition, these rules must satisfy minimum confidence. 

Apriori employees an iterative approach known as a level-wise search, where k-itemsets are used to explore 
(k+1)-itemsets. First, the set of frequent 1-itemsets is found. This set is denoted L1. L1 is used to find L2, the set of frequent 2-itemsets, which is used to find L3, and so on, until no more frequent k-itemsets can be found. The finding of each Lk requires one full scan of the database. An important property called Apriori property, based on the observation is that, if an itemset I is not frequent, that is, P(I ) < min_sup then if an item A is added to the itemset I, 
the resulting itemset (i.e., I ∪ A) cannot occur more frequently than I. Therefore, I ∪ A is not frequent either, that is, P(I∪ A) < *min_sup*. To understand how Apriori property is used in the algorithm, let us look at how *Lk-1* is used to find Lk
. A two-step process is followed, consisting of join and prune actions. 

 The join step: To find Lk
, a set of candidate k-itemsets is generated by joining *Lk-1* with itself. This set of candidates is denoted by Ck
. Let l1 and l2 be itemsets in *Lk-1* then l1 and l2 are joinable if their first *(k-2)* items are in common, i.e., (l1[1]=l2[1]) . (l1[2]=l2[2]) .….. (l1[k-2]=l2[k-2]) . (l1[k-1]<l2[k-1]). 

 The prune step: Ck is the superset of Lk
. A scan of the database to determine the count of each candidate in Ck would result in the determination of Lk (itemsets having a count no less than minimum support in Ck
). But this scan and computation can be reduced by applying the Apriori property. Any *(k-1)*-itemset that is not frequent cannot be a subset of a frequent k-itemset. Hence if any *(k-1)*-subset of a candidate k-itemset is not in *Lk-1*, then the candidate cannot be frequent either and so can be removed from Ck
.. 

## 2.4 Illustration Of Apriori Algorithm

Consider an example of Apriori, based on the following transaction database, D of Figure: 1, with 9 transactions, to illustrate Apriori algorithm. In the first iteration of the algorithm, each item is a member of the set of candidate 1-itemsets, C1 The algorithm simply scans all of the transactions in order to count the number of occurrences of each item. If minimum support count is set to 2,frequent 1-itemsets, *L1 ,* can then be determined from candidate 1-itemsets satisfying minimum support [6]. 

To discover the set of frequent 2-itemsets, *L2, the* algorithm uses L1 | L1 to generate a candidate set of 2itemsets (Figure: 4). 

 The transactions D are scanned and the support count of each candidate itemset in C2 is accumulated (Figure: 5). 

 The set of 2-itemsets, L2 (Figure: 6), is then determined, consisting of those candidate 2-itemsets in C2 having minimum support. 

The generation of the set of candidate 3-itemsets, C3 , is detailed in Figure: 7 to *Itemset Sup. count* Here C3 = L2 | L2 = {{I1,I2,I3},{I1,I2,I5}, {I1,I3,I5}, {I2,I3,I5}, {I2,I4,I5}}.Based on the Apriori property that all subsets of a frequent itemset must also be frequent, the resultant candidate itemsets will be as in Figure: 7. 

The transaction in D are scanned in order to determine L3 , consisting of those candidate 3-itemsets in C3 having minimum support (Figure: 9). The algorithm uses L3 | L3 to generate a candidate set of 4-itemsets, *C4 .* Although the join results in 
{{I1,I2,I3,I5}}, this itemset is pruned since its subset {{I2,I3,I5}} is not frequent. Thus, C4 = {}, and the algorithm terminates. 