Let us consider an example of Apriori, based on the following transaction database, D of figure 4.1, with 9 transactions, to illustrate Apriori algorithm. 

Itemset Sup. 

count 

{l1} 6 {l2} 7 {l3} 6 {l4} 2 {l5} 2 

| TID   | List of item_IDs   | {l1}   | 6   |
|-------|--------------------|--------|-----|
| {l2}  | 7                  |        |     |
| {l3}  | 6                  |        |     |
| {l4}  | 2                  |        |     |
| {l5}  | 2                  |        |     |
|       |                    |        |     |

Figure 1. Transactional Data **Figure 2.** Generation of C1 **Figure 3.** Generation of L1 

| count   | Itemset   | Sup. count   |
|---------|-----------|--------------|
| {l1}    | 6         |              |
| {l2}    | 7         |              |
| {l3}    | 6         |              |
| {l4}    | 2         |              |
| {l5}    | 2         |              |

In the first iteration of the algorithm, each item is a number of the set of candidate 1-itemsets, C1. The algorithm simply scans all of the transactions in order to count the number of occurrences of each item. Suppose that the minimum transaction support count required is 2 (i.e.; min_sup = 2/9 = 22%). The set of frequent 1-itemsets, L1, can then be determined. It consists of the candidate 1-itemsets satisfying minimum support. To discover the set of frequent 2-itemsets, L2, the algorithm uses L1 | L2 to generate a candidate set of 2-itemsets, C2. The transactions in D are scanned and the support count of each candidate itemset in C2 is accumulated. 

Figure 4. Generation of C2 **Figure 5.** Generation of L2 
 
Itemset Sup.count 

![0_image_2.png](0_image_2.png)

 

| Itemset   | Sup.count   |         |           |
|-----------|-------------|---------|-----------|
| {l1, l2}  | 4           |         |           |
| {l1, l3}  | 4           |         |           |
| {l1, l4}  | 1           |         |           |
| {l1, l5}  | 2           |         |           |
| {l2, l3}  | 4           |         |           |
| {l2, l4}  | 2           |         |           |
| {l2, l5}  | 2           |         |           |
| {l3, l4}  | 0           |         |           |
| {l3, l5}  | 1           |         |           |
| {l4, l5}  | 0           | Itemset | Sup.count |
| {l1, l2}  | 4           |         |           |
| {l1, l3}  | 4           |         |           |
| {l1, l5}  | 2           |         |           |
| {l2, l3}  | 4           |         |           |
| {l2, l4}  | 2           |         |           |
| {l2, l5}  | 2           |         |           |

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

![0_image_3.png](0_image_3.png)

 Figure 6. Generation of C3 **Figure 7.** Generation of L3 