where L is the Lagrange function of Eq. (1), ξ =
[ξ1, ξ2, . . . , ξl], α = [α1, α2**, . . . , α**l] and αi ≥ 0. Feature vector xi such that αi 6= 0 is called a support vector.

Eq. (1) can be transformed into its dual form, which also allows the use of kernel tricks:

$$\begin{array}{ccccc}\max&-\frac{1}{2}\alpha^{T}\mathbf{Q}\alpha&+&\frac{1}{2}1^{T}\alpha\\ s.t.&\sum_{i=1}^{l}y_{i}\alpha_{i}=0\\ \alpha_{i}&\geq0,i=1,\ldots,l\end{array}\tag{3}$$

where Q is a matrix whose element at i-th row and j-th column is Qij = yiyjφ(xi) · φ(xj ), and φ is a function, e.g., linear or radial basis, of the feature vector.

![0_image_0.png](0_image_0.png)

## B. Scaled Svm

Due to the sparseness of α, the hyperplane is only related to a few points while other points have no influence. Therefore, C-SVM loses some robustness. Based on this observation, Feng [6] proposed Scaled SVM taking the distribution scale (range) of two classes into consideration.

This method can advance C-SVM by at most 10% on average generalization error.

Assume two classes A1 and A2 in one dimension are distributed in intervals (0, a) and (−b, 0) respectively, where a, b > 0. Let s1 be the hyperplane obtained by C-SVM.

Denote d1 and d2 as the distribution scales of A1 and A2, respectively. Let c1 and c2 be the distances from s2 to the nearest points in A1 and A2, respectively. According to Scaled SVM, in parallel with s1, the new hyperplane s2 satisfies:

$${\frac{c_{1}}{c_{2}}}={\sqrt{\frac{d_{1}}{d_{2}}}}\ ,$$

as illustrated in Fig. 1.

Eq. (4) can be reformulated into:

$$x_{new}=x_{old}+\Delta=x_{old}+\frac{2(\sqrt{d_{2}}-\sqrt{d_{1}})}{\sqrt{d_{1}}+\sqrt{d_{2}}}\,\tag{5}$$

where xold and xnew are the locations of s1 and s2 respectively. The calculation of ∆ in multi-dimensional case will be determined later in the paper.

## C. Related Work

There have been many works which aim at combining the global information into C-SVM. Huang *et al.* proposed a new large margin classifier called Maxi-Min Margin Machine (M4) which use the covariance information of two classes [7]. Yeung *et al.* first used clustering algorithms to determine the structure of data, then incorporated this structural information into constraints to calculate the largest margin [8]. In contrast to integrating global information into constraints, Xue *et al.* [9] proposed Structural Support Vector Machine, which embeds global information into the CSVM's objective function. This approach greatly reduces the computational complexity while keeping the sparsity merit of C-SVM. Xiong and Cherkassky proposed SVM/LDA which combined LDA and SVM together [10]. The SVM part reflects the local information of the data while the LDA part reflects the global information. Takuya and Shigeo improved the generalization ability of C-SVM by optimizing the bias term based on Bayesian theory [11].

## A. Overview Iii. Our Proposed Method

To a binary classification task, C-SVM will put the hyperplane in the middle of the margin. However, since the distributions of two classes are usually different, it makes sense to translate the hyperplane away from the class of larger variance and toward the other class. An illustration is shown in Fig. 2.

![0_image_1.png](0_image_1.png)

$$(4)$$

Let the translating distance of the hyperplane be ∆. The new SVM is the solution of the optimization problem below:

$$\begin{array}{ll}\min&\|{\bf w}\cdot{\bf w}\|+C\sum_{i=1}^{l}\xi_{i}^{2}\\ s.t.&\left\{\begin{array}{l}y_{i}({\bf w}\cdot{\bf x}_{i}+b)\geq1+\Delta-\xi_{i},\ \mbox{if}\ y_{i}=+1\\ y_{j}({\bf w}\cdot{\bf x}_{j}+b)\geq1-\Delta-\xi_{j},\ \mbox{if}\ y_{j}=-1\end{array}\right.\end{array}\tag{6}$$
Without losing of generalization, $i=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, $j=1,2,\ldots,l^{+}$, \(j=1,2,\ldots,l^{
l
+ + 1**, . . . , l**, and l
+ is total number of positive class.

The solution of Eq. (6) is called a General Scaled SVM.