The Lagrange function of Eq. (6) is:

$$\begin{array}{r c l}{{{\cal L}}}&{{=}}&{{\frac{1}{2}\|{\bf w}\cdot{\bf w}\|+\frac{C}{2}\sum_{i=1}^{l}\xi_{i}^{2}}}\\ {{}}&{{}}&{{}}\\ {{}}&{{}}&{{-}}&{{\sum_{i=1}^{l+}\alpha_{i}[y_{i}({\bf w}\cdot{\bf x}_{i}+b)-1-\Delta+\xi_{i}]}}\\ {{}}&{{}}&{{}}\\ {{}}&{{}}&{{-}}&{{\sum_{j=l^{+}+1}^{l}\alpha_{j}[y_{j}({\bf w}\cdot{\bf x}_{j}+b)-1+\Delta+\xi_{j}]}}\end{array}$$
Eq. (6) is equivalent to i=1 yiαixi + ∂∆ ∂w   l X+ i=1 αi −X l j=l++1 αj  ∂L ∂w = w −X l  = w −X l i=1 yiαixi + ∂∆ ∂w X l i=1 αiyi = w −X l (7) i=1 yiαixi = 0 ∂L ∂ξ = Cξ − α = 0 ∂L ∂b =X l i=1 αiyi = 0
Since Eq. (7) is identical to Eq. (2) (of C-SVM) and L
is independent from ∆, this problem can be solved in three steps:
1) Use the C-SVM algorithm to obtain the original hyperplane.

2) Project all the points onto the normal vector of the hyperplane and estimate the distribution of each class in the projection.

3) Calculate ∆ and translate the original hyperplane to obtain the new one.

![0_image_0.png](0_image_0.png)

## B. Calculating ∆

After obtaining w from C-SVM training, we project data points onto the normal vector of the hyperplane. Then we utilize the projected scale of each class to adjust the hyperplane. This is illustrated in Fig. 3. Feng's conclusion for 1-D SVMs can be extended to multi-dimensional case.

In the input space, the projected coordinate of any data point xi on the normal vector of the hyperplane is:

$$e_{i}={\frac{\mathbf{w}\cdot\mathbf{x}_{i}}{\|\mathbf{w}\|}}\qquad\qquad\qquad(8)$$

Projected scales can be calculated as:

$$\begin{array}{r c l}{{d_{1}}}&{{=}}&{{\operatorname*{max}\mathbf{E}_{+}-\operatorname*{min}\mathbf{E}_{+}}}\\ {{d_{2}}}&{{=}}&{{\operatorname*{max}\mathbf{E}_{-}-\operatorname*{min}\mathbf{E}_{-}}}\end{array}$$
$$d_{2}=\max{\bf E}_{-}-\min{\bf E}_{-}$$  where ${\bf E}_{+}=\{e_{i}|y_{i}=+1\}$ and ${\bf E}_{-}=\{e_{i}|y_{i}=-1\}$.  With $d_{1}$ and $d_{2}$, $\Delta$ can be calculated as in Eq. (5):
$$\Delta={\frac{2({\sqrt{d_{2}}}-{\sqrt{d_{1}}})}{{\sqrt{d_{1}}}+{\sqrt{d_{2}}}}}$$

Note that ∆ ranges from −1 to 1.

In feature space, where all data points x are mapped into φ(x), since w =Pli=1 αiφ(xi), all we need to do is replacing hxi· xj i with K(xi, xj ).

## Iv. Experiments

In this section, we first demonstrate the advantage of GSSVM on synthetic 2-D toy data sets. Then we compare GS-SVM with C-SVM on several real world benchmarks. The training and testing of SVMs are accomplished by LIBSVM [12].

## A. 2-D Toy Data

As illustrated in Fig. 4(a), the data set is generated under two Gaussian distributions: the positive class is randomly sampled from the Gaussian distribution with the mean as
[0.2, 0.1]Tand the covariance as [0.5, 0.**2; 0**.2, 0.4], while the negative class is randomly sampled from another distribution with the mean and the covariance as [1.7, 1.7]T
and [0.4, −0.2; −0.2, 0.4]. Training and test sets consist of 30 and 60 data points respectively for each class. Fig. 4(b)
illustrates the hyperplanes derived by C-SVM and GSSVM. From Fig. 4(b), we find that GS-SVM achieves a better hyperplane by taking both the local and global information of the data into consideration when determining the position of the hyperplane. As expected, the GS-SVM translates the hyperplane toward the class (negative class) of smaller projected scale on the normal of the hyperplane. GSSVM classifies two more points correctly. The classification accuracies of C-SVM and GS-SVM are 96.67% and 97.5%
respectively. The improvement on accuracy demonstrates the advantage of our proposed method.