Let A and B be two finite sets of arbitrary elements. A *matching* of elements of sets A and B is a set of pairs M = {(i, j)|i ∈ *A, j* ∈ B} such that no element of one set is paired with more than one element of the other set. For the matching M we define enumeration functions f : {1, 2, . . . k} → A and g : {1, 2, . . . k} → B such that M = {(f(l), g(l))|l = 1, 2*, . . . , k*} where k = |M|. Let w(*a, b*) be a function assigning weights to pairs of elements a ∈ A and b ∈ B. The goal of the *assignment problem* is to find a matching of elements of A and B with the highest sum of weights (if two sets are of different cardinalities, some elements of the larger set will not have corresponding elements in the smaller set). The assignment problem is usually solved by the well-known Hungarian algorithm of complexity O(mn2) where m = max(|A|, |B|) and n = min(|A|, |B|) [8].

There are more efficient algorithms, such as one due to Edmonds and Karp of complexity O(mn log n) [9] and even more efficient one, due to Fredman and Tarjan of complexity O(mn + n 2log n) [10].

## 3. Existing Methods For Measuring Graph Node Similarity

In this section we briefly describe relevant iterative methods for measuring similarity of graph nodes and we try to identify some desirable properties that they lack.

Assume that two directed graphs GA = (VA, EA) and GB = (VB, EB) are given. Iterative methods calculate similarity of nodes of these two graphs by repeatedly refining the initial estimate of similarity using some update rule of form [x k+1 ij ] ← f([x k ij ]). Iterations are performed until some termination condition is met. At the end, the similarity matrix X = [xij ] is produced.

Different rules for update of similarity of two nodes are proposed. They usually include summing all the similarities between the neighbors of first node and the neighbors of the second node.

One of the first influential iterative approaches is due to Kleinberg [1], further generalized by Blondel et al. [3]. In the method of Blondel et al. the update rule for xij in step k + 1 is given by

$$x_{i j}^{k+1}\leftarrow\sum_{(p,i)\in E_{A},(q,j)\in E_{B}}x_{p q}^{k}+\sum_{(i,p)\in E_{A},(j,q)\in E_{B}}x_{p q}^{k}.$$

The similarity matrix X is normalized by X ← X/kXk2 after each step.

The earlier approach by Melnik et al. [5] can be seen as a more general version of of this method where the similarities between neighbor nodes x k pq are weighted.

The method of Blondel et al. was modified by Zager and Verghese [4] to take into account similarity of the edges too. The update rule for the edge similarity matrix Y = [yuv], where u ∈ EA and v ∈ EB, is given by

* [16] A. A. K.  
y k+1 uv ← x k s(u)s(v) + x k t(u)t(v)
.