left hand corresponds one finger of the right hand that is very similar to it.

By analogy, the concept of similarity can be refined - two nodes i ∈ VA and j ∈ VB are considered to be similar if neighbor nodes of i can be matched to similar neighbor nodes of j (hence the name neighbor matching).

## 4.2. Measuring Similarity Of Graph Nodes

As in other related methods, similarity scores are calculated as the fixed point of the iterative procedure defined by some update rule. In our method, we will differentiate between in-similarity sin and out-similarity sout and will give them equal weights. In order to calculate in-similarity, the matching of in-neighbors with maximal sum of similarities (as described in Section 2) has to be constructed, and analogously for out-similarity. More formally, the update rule is given by

$$x_{i j}^{k+1}\leftarrow\frac{s_{i n}^{k+1}(i,j)+s_{o u t}^{k+1}(i,j)}{2}.$$
In and out similarities are defined by:  $\color{white}\Lambda^{ind}_{\mu\nu}$
a and out similarities are defined by  $$\begin{split}s_{in}^{k+1}(i,j)\gets\frac{1}{m_{in}}\sum_{l=1}^{n_{in}}x_{ij}^{k}(l)g_{ij}^{in}(l)\qquad\qquad s_{out}^{k+1}(i,j)\gets\frac{1}{m_{out}}\sum_{l=1}^{n_{out}}x_{ij}^{k}{}_{ij}^{out}(l)g_{ij}^{out}(l)\\ m_{in}=\max(id(i),id(j))\qquad\qquad m_{out}=\max(od(i),od(j))\end{split}\tag{1}$$
$${\mathrm{finned~by}}$$

where functions f
in
ij and g
in
ij are the enumeration functions of the optimal matching of in-neighbors of nodes i and j with weight function w(*a, b*) = x
k
ab. In the
equation 1, we define 00
to be 1. This convention ensures that the similarity of
$$\begin{array}{l l}{{m_{i n}=\operatorname*{max}(i d(i),i d(j))}}&{{\qquad m_{o u t}=\operatorname*{max}(o d(i),o d(j))}}\\ {{}}&{{n_{i n}=\operatorname*{min}(i d(i),i d(j))}}&{{\qquad n_{o u t}=\operatorname*{min}(o d(i),o d(j))}}\end{array}$$
nodes with no in or no out neighbors is recognized. If there is a difference in
the number of in or out neighbors, that difference is penalized when calculating
corresponding similarities since min and mout are greater than the number of
terms in the summation (which are each less or equal to 1 as we show later).
This method is easily extended to colored graphs. By definition, we can set
x
k
ij to be 0 if nodes i and j are of different color.
As in other iterative methods, one has to choose the initial similarity scores
x
0
ij . In our method, we set x
0
ij = 1 for all i ∈ EA, j ∈ EB. Though the choice
may seem arbitrary, note that in the first iteration it leads to intuitive results.
$$s_{i n}^{1}=\frac{\operatorname*{min}(i d(i),i d(j))}{\operatorname*{max}(i d(i),i d(j))}\qquad\quad s_{o u t}^{1}=\frac{\operatorname*{min}(o d(i),o d(j))}{\operatorname*{max}(o d(i),d(j))}$$
If, for instance, a node i has 3 in-neighbors and a node j has 5 in-neighbors, the in-similarity of nodes i and j in the first iteration will be 35
. We find that to be an intuitive choice if we don't yet know anything about the similarities of the neighbor nodes - in that case we can only reason about the number of neighbor nodes.

The termination condition is maxij |x k ij−x k−1 ij | < ε for some chosen precision ε. Alternative termination condition could be used too.