2.0 HILL-DOES Methodology: **The system developed to find numerical solutions of** Diophantine equations using Hill climbing is based on the Steepest Ascent version of Hill Climbing and is called HILL-DOES. It uses a system of equations given by 
 
 a1 . x1
$$\mathbf{a_{1}}\,.\,\mathbf{x_{1}}\,^{\mathrm{{p1}}}+\mathbf{a_{2}}\,.\,\mathbf{x_{2}}\,^{\mathrm{{p2}}}+........+\mathbf{a_{n}}\,.\,\mathbf{x_{n}}\,^{\mathrm{{pn}}}=\mathbf{N}$$
pn **= N (6)** 
$$(6)$$

where ai **and N are integers, for demonstrating the effectiveness of the system proposed.** 
2.1 Representation: **The possible solutions of the Diophantine equation (6) are represented** by a tree whose nodes are taken as n-vectors given by (x1, x2, …, xn**). The procedure starts with an** initial solution, given to be (1, 1, 1, ….. , 1) and uses two queues in its construction. The first queue, which is called PROBE-Q, is used to store the nodes, which have been probed. The second queue, which is referred as NOPROBE-Q, is used to store the nodes, which have been generated but not better than the current node. These two queues help to separate the generated nodes into two distinct classes - 'probed nodes' and 'not-probed nodes'. 

2.2 Successor nodes: **Successor nodes of the current node are generated in HILL-DOES** 
using specially defined production rules. The production rules applied are given by: 

$\left(7\right)$. 
$$(\delta)$$
(x1, x2, …, xi , …. , xn)  (x1, x2, …, xi+1 , …. , xn**) for i =1, 2, …., n (7)** 
These production rules help to generate all possible nodes in the vicinity of the current node. Hill climbing, being a local search technique, needs to explore all possible nodes within the neighborhood of the current node. The successor nodes generated in this way, take care of this requirement of the search strategy. 

2.3 Heuristic function: **The heuristic function used to evaluate the effectiveness of a node** (x1, x2, x3, …., xn**) in the search process is given by** 
 
$$\mathrm{H(x_{1},x_{2}\,....,x_{n})=N-\left(a_{1}x_{1}^{p1}\,+\,a_{2}x_{2}^{p2}\,+\,a_{3}x_{3}^{p3}\,+\,............\,+\,a_{n}x_{n}^{p n}\,\right)}$$
pn **) (8)** 
Since the objective of the procedure is to find numerical solutions of equation (6), the problem reduces to find a vector given by (x1, x2, …, xn) with H(x1, x,2 ….., xn**) = 0. The value of 'H' shows** how far is a given node away from the goal node. Lower the value of 'H', closer is the node to the solution. However, the negative value of 'H' requires some extra care to make the search process on track. Whenever H value becomes negative, the proposed procedure does not expand the corresponding node even if that has better heuristic function value compared to others. Instead, the node with the next better heuristic function value is expanded and the process is continued. In other words, the nodes having negative H values are replaced with the better nodes from the NO-PROBEQ. 2.4 Backtracking**: It is possible to have a current node, with all its successor nodes having** 
inferior heuristic values in comparison with that of the current node. Steepest ascent hill climbing always demands having better nodes as successor nodes to continue the procedure. This drawback of hill climbing is overcome in the procedure by incorporating a strategy of backtracking. As per this, when the procedure fails to produce better nodes as successor nodes, it leaves the current node and goes back or backtracks to the previous best node generated. Then, the exploration process resumes from that node and the process of traversing through the tree in another path is followed. It is quite possible that during the search process, the procedure might hit on such inferior successor nodes on a regular basis. At these instances, the procedure 