lows: Each of the k **leaves is associated with a distinct**
class, and each internal node is associated with the union of the class subsets of its right and left children. Each such tree defines a hierarchical partition of the set of classes and the idea is to train a binary classifier for each internal node so as to discriminate between the class subset of the right child and the class subset of the left child. Note that in a full binary tree with k leaves there are k − **1 internal nodes.**
Once these tree classifiers are trained, the classification or "decoding" of an new instance can be done using various approaches. One natural decoding method would be to use the tree in a decision-tree fashion: Start with the binary classifier at the root and let this classifier determine either its right or left child, and this way follow a path to a leaf and assign the class associated with this leaf. This approach is particularly convenient when using *hard* binary classifiers giving labeles in {±1}**. When using "soft" (confidence-rated)**
and in particular probabilistic classifiers, giving confidence rates in [0, **1], a natural decoding method would**
be to calculate an estimate for the probability of following the path from the root to each leaf and then use a "winner-takes-all" approach, which selects the path with the highest probability.

Besides computational efficiency, the success of any multiclass decomposition scheme depends on (at least)
two interrelated factors. The first factor is the statistical "hardness" of each of the individual binary classification problems. The second factor is the statistical robustness of the aggregation (or "decoding") method. The most fundamental measure for the hardness of a classification problem is its *Bayes error***. We attempt** to use the Bayes error of the resulting decomposition and aim to hierarchically decompose the multiclass problem so as to construct statistically "easy" collection of binary problems.

Determining the Bayes error of a classification problem based on the data (and without knowledge of the underlying distributions) is a hard problem, without any restrictions (?**). In this paper we restrict ourselves** to settings where the underlying distributions can be faithfully modelled as *multinomials***. Potential application areas are classification of natural language, biological sequences etc. We can therefore in principle**
conveniently rely on studies, which offer efficient and reliable density estimation for multinomials (?; ?; ?; ?**). As a first approximation, throughout this paper**
we make the assumption that we hold "ideal" data smaples and simply rely on maximum likelihood estimators that count occurrences.

But even if the underlying distributions are known, a faithful estimation of the Bayes error is computationally difficult. We rely on known information theoretic bounds on the Bayes error, which can be efficiently computed. In particular, we use Bayes error bounds in terms of the Jansen-Shannon divergence (?**) and we**
derive upper and lower bounds on the inherent classification difficulty of hierarchical multiclass decompositions. Our bounds, which are tight in the worst case, can be used as optimality measures for such decompositions. Unfortunatelly, the translation of our bounds into provably efficient algorithms to search for high quality decompositions appear at the moment computationally difficult. Therefore, we use a simple and efficient greedy heuristic, which is able to generate reasonable decompositions.

We provide initial empirical evaluation of our methods and test them on multiclass problems of varying sizes in the application area of 'authorship determination'. Our hierarchical decompositions consistently improve on the 'all-pairs' method when the number of classes are small but do not outperform all-pairs with larger number of classes. The authorship determination set of problems we consider is taken from a new benchmark collection consisting of machine learning authors. The absolute accuracy results we obtain are particularly high compared to standard results in this area.

## 2. Preliminaries: Bounds On The Bayes Error And The Jensen-Shannon Divergence

Consider a standard binary classification problem of classifying an observation given by the random variable X into one of two classes C1 and C2. Let π1 and π2 denote the priors on these two classes, π1 + π2 = 1 with πi ≥ 0. Let pi(x) = p(X = x|Ci), i = 1, **2, be**
the class-conditional probabilities. If X = x **is observed then by Bayes rule the posterior probability of**
Ciis p(Ci|x) = πipi(x)
π1p1(x)+π2p2(x)
. If all probabilities are known we can achieve the Bayes error by choosing the class with the larger posterior probability. Thus, the smallest error probability is

$$p(e r r o r|x)={\frac{\operatorname*{min}\{\pi_{1}p_{1}(x),\pi_{2}p_{2}(x)\}}{\pi_{1}p_{1}(x)+\pi_{2}p_{2}(x)}}$$

and the Bayes error is given by R
pBayes = p(error) =
x p(x)p(error|x)dx = Ex[min{π1p1(x), π2p2(x)}].

The Bayes error quantifies the inherent difficulty of the classification problem at hand (given the entire probabilistic characterization of the problem) without any