

![0_image_0.png](0_image_0.png)

In iDian"s way, all these steps are reduced into typing one sentence that directly describes the requirement: "Delete carriage returns in each line". By typing this sentence, the user need not to care about the implementation within iDian, and just need to wait up a few milliseconds to see the task completed as in Figure 4. In fact, lots of operations could be performed in this way, all of which require only one sentence as input, like "Transform numbers in lines 1-3 to inferior characters", and "Email this document to *Xi Wang*", etc. Some of the operations appear to be a piece of cake for skilled computer users, but some are not. For computer beginners and the numerous "permanent intermediate users", the reason why they prevent using advanced functions of a program is not that they have none such requirements, but that they are tired or afraid of searching the menus. 

By using iDian, the obstacles are overcome for people to approach advanced functions and combinations of basic functions of applications.

![0_image_2.png](0_image_2.png)

Here is another example: *Autodesk Maya* is a famous software application used for 3D-modelling and animation. Although it"s said that Maya is easy to learn, it is really difficult to master. Through iDian, Maya beginners are easily to get access to basic functions and get familiar with the operations more quickly, while advanced users will save much time for basic operations.

![0_image_3.png](0_image_3.png)

Sometimes the user wants to see quick effects of an operation. In such cases, using iDian becomes the best solution, where there is no need to adjust various parameters in dialogs; everything the user has to do is just to state her/his demand and press Enter before she/he abandons trying the idea. It does like command-line to some extent, yet it provides much freer space for users to organize their expressions much more naturally.

The iDian"s support for *Maya* is currently experimental, which means the amount of available actions is limited at the moment. We used MEL language as the interface to control *Maya*, and are planning to provide online-help functions.

## Structure And Mechanism Of Idian

The iDian"s employs a multi-layer structure, consisting of a syntactic 

![0_image_1.png](0_image_1.png) layer, a semantic layer, an explainer, an executor, and a leaner. Figure 6 depicts an outline of the structure and workflow within iDian.

## Syntactic Layer:

As demonstrated by Figure 6, when the user types a sentence in natural language, the sentence is firstly imported into Syntactic Layer, where the sentence is segmented, looked up in dictionary and transformed to integer numbers. Due to the synonym phenomenon, there is usually more than one word corresponding to an index number. 

The quotations are also extracted at this step, where a temporary index will be distributed to each of the numbers and quotations.

## Semantic Layer:

Then the indices" array comes to Semantic Layer with quotations appended. In this layer, a series of number-format transformations are firstly performed, resulting in NUMFORMAT, a structure that describes all types of numbers, including ordinal numbers, **cardinal** 
numbers, **ranges** and **arrays**, and an additional flag is set to distinguish **absolute numbers** and **relative numbers**.

After NUMFORMAT transformation, general rule-based translation and specific rule-based translation are separately performed. The distinction between the two kinds of transformations is that: the former is suitable to all applications, and the latter is specific to each application. Several special **wildcard characters** are employed, including "*N", "?N", "\#N" and "!N", where N corresponds to word ordering or class serial number, "\#" stands for temporary classes, and "!" stands for part-of-speech classes. We found that transformations with these four kinds of wildcard characters are sufficient to transform ordinary imperative sentences in Chinese into regular expressions that are recognizable by Explainer in the next step. Although the models are carefully written so that the user"s commands could be correctly parsed as many as possible, recursive or hierarchical combinations of modifiers in the sentence are not well supported by current rule-based model - the semantic layer will sometimes produce incorrect results by making wrong assumptions. This problem should be resolved by introducing more knowledge about semantic processing or employing statistical methods based on corpus and large datasets.