
## Explainer:

The output of Semantic Layer is still a number array, but the whole sentence is rearranged into regular order, so that Explainer in the next step could directly separate the parts of the sentence. The functional parts of the sentences are tagged **Action** (VP), **Primary Object** (NP), Secondary Object (NP, Optional) and **Conditions** (PP, Optional), 
and then delivered to Executor whenever a clear end or start of a tagged-part is recognized. An "End" message is sent by Explainer when the input array reaches its end, and will start the execution process in the final step. For example, if the input sentence is "Replace "apple" with "peach" in lines 1-10 that contain "orange" and 
"bread"", then the output of semantic layer will be like "Replace in [Number 0] line has-and [Quotation 2] [Quotation 3] [Quotation 0] with [Quotation 1]" (the words are represented by numbers in reality). 

And Explainer will tag the elements of the command as follows:

| Tag                                                                 | Content                                                    | Index     | Corresponding Extra Data   |
|---------------------------------------------------------------------|------------------------------------------------------------|-----------|----------------------------|
| Action                                                              | Replace                                                    | 1011      |                            |
| Primary Object                                                                     | [Quotation 0]                                              | 5000      | "apple"                    |
| Secondary                                                           | [Quotation 1]                                              | 5001      | "peach"                    |
| Object Condition [0]                                                | In [Number 0]                                              | 3002 6000 | [Absolute][Range] 1, 10    |
| line                                                                | 2015                                                       |           |                            |
| Condition [1]                                                       | Has-and  [Quotation 2] [Quotation 3]                       | 3005 5002 | "orange"                   |
| 5003                                                                | "bread"                                                    |           |                            |
| Table 1                                                             | Example output of Explainer. Note: All language models are |           |                            |
| actually based on Chinese, while this is only a translated version. |                                                            |           |                            |

In the example above, the preposition "with" is recognized as a switch between primary object and secondary object. Besides, there are three quotations appear continuously in Semantic Layer"s output, but only Quotation 2 and 3 are recognized as part of Condition 1, due to the regulation of the previous preposition "has-and", which is produced during the general rule-based transformations.

## Executor:

Upon receiving the "End" message from Explainer, Executor begins to perform the operation by sending messages to application. Implementations of Executor varies with the method it controls the target application. Although it is quite complicated to realize Executor, it has much less theoretical difficulties than the previous steps. Also, we are expecting newly distributed programs to actively offer a better interface for iDian.

Usually, Executor performs the operation in a similar way that IMEs
(Input Method Editors) send messages to applications. However, Executor will not make one-one mapping between the combinations of regular tasks and the exact functions of the software. After all, the number of the combinations is infinite, therefore inside Executor a mechanism is established to verify all the conditions and map the primary object and secondary object to real targets in the application.

This process ensures that every reasonable expression generated by the user would be precisely performed in its original intention, as long as it is "feasible" by **direct combinations** of currently supported operations, where "direct" means that every element of the expression has to be conceptually clear and well-defined whether in the application or within Executor. For example, the expression "Make an outline of the last two paragraphs" will possibly get through the first three layers, but will confuse Executor, unless "outline" as a primary object under the action "make" is mapped to the function "Generating Abstract" of the application, or defined as a 
-3-

## Process Within Executor.

The user interface of iDian will not permanently stay on top of the screen - its behavior is much like a "**transient posture program**", 
which "is invoked when needed, appears, performs its job, and then quickly leaves, letting the user continue her normal activity, usually with a sovereign application." [Alan Cooper, About *Face 3*] Only when the user is confused with some specific operation of a program, she/he will "wake up" iDian for help.

## Learner:

There is no need for Learner"s existence if all the procedures above always succeed and produce satisfactory results, which is nearly impossible. Learner collects all the failure feedbacks from kernel modules (Syntactic Layer, Semantic Layer and Explainer), and make suggestions on possible **alternative expressions** regarding on different layers.

If unrecognizable characters (either Chinese characters or symbols)
appear in the sentence, they are firstly combined and considered as a quotation. Then the sentence is retried by the proceeding procedures, in case that the user forgets or is unwilling to type quotation marks. If this fails again, the characters will be considered as potential new words and compared to existing words in keyword-dictionary.

Through the comparison, a thesaurus dataset is employed to compute the distance between each two words, and a certain number of words that are nearest to the potential new words are listed as suggestions. 

The user"s selection will cause refreshing of the keyword-dictionary.

If this process doesn"t work either, the user will be asked to change her/his expression, and the previous one will be regarded as a special expression for the same meaning. When special expressions have been accumulated to some amount, the local structural formats will be clustered in semantic layer, so that new rules could be learned and iDian would better accommodate the user"s habits. The clustering and learning algorithms are to be implemented in the near future.

Learner also provides an important feature, **online support**. All the databases within iDian can be uploaded and downloaded online, including the keyword-dictionary, the synonym-dictionary, the NUMFORMAT transformation rules, and the general transformation rules. For software developers, they can easily add support for iDian to their new applications by providing **the special suit**, which consists of supplemental dictionaries, specific transformation rules and an Executor that recognizes and deals with actions, primary and secondary objects and conditions sent from Explainer. Special suits can also be shared online, and dynamically integrated into iDian"s system, so that skilled users could exchange their knowledge on application operations.

## Discussion

The goal of iDian is to smooth the way to efficient computer operations, and to liberate people from repetitive works in front of the screen. Modern integrated software applications offer much more functions than we actually require, but it"s still a difficult task for beginners and intermediate users to find the appropriate method to accomplish their job quickly enough. We are so easily confused in searching a large number of unnecessary buttons and menus for a simple function we assumes to be reasonable, but in most cases we turn to the Internet for help, otherwise we would abandon our ideas or degrade our requirement. With iDian, we can directly input our need and press Enter (just like pressing "*I'm Feeling Lucky*"), and will usually turn out to be "lucky". What iDian provides is a method to handle advanced operation skills with least conditions, far more than a simple search and access tool.