# A Protocol For Self-Synchronized Duty-Cycling In Sensor Networks: Generic Implementation In Wiselib

H. Hern´andez1, T. Baumgartner2, M. J. Blesa1, C. Blum1, A. Kr¨oller2and S. P. Fekete2 1 ALBCOM Research Group Universitat Polit`ecnica de Catalunya, Barcelona, Spain
{hherandez,mjblesa,cblum}@lsi.upc.edu 2 Algorithms Group Braunschweig Institute of Technology, Braunschweig, Germany
{t.baumgartner,a.kroeller,s.fekete}@tu-bs.de

## Abstract 1

In this work we present a protocol for self-synchronized duty-cycling in wireless sensor networks with energy harvesting capabilities. The protocol is implemented in Wiselib, a library of generic algorithms for sensor networks. Simulations are conducted with the sensor network simulator Shawn. They are based on the specifications of real hardware known as iSense sensor nodes.

The experimental results show that the proposed mechanism is able to adapt to changing energy availabilities. Moreover, it is shown that the system is very robust against packet loss.

## 1 Introduction

Sensor networks [14] consist of a set of small, autonomous devices which may be used, for example, for environmental monitoring, patient monitoring in health care, and industrial machinery surveillance. As sensor nodes may be distributed in areas without power supply, or they may be mobile, they are generally equipped with batteries, which makes energy a scarce resource. A basic idea for saving energy is to periodically switch off the sensor nodes. The mechanism that establishes the alternation between the active and inactive states is generally called *duty-cycling* (see, for example, [13]). In some cases, duty-cycling is energy-aware (see, for example, [9, 11, 10]). The main disadvantage of these approaches is that they require a quite regular pattern for the availability of energy from the environment.

In previous work [8, 7, 6] we introduced and studied a possible technique for energy-aware dutycycling in (mobile) sensor networks with energy harvesting capabilities. This system is inspired by self-synchronized sleeping patterns of natural ant colonies [4]. The focus of these first studies was purely on the swarm intelligence aspects of the proposed system. The experiments were performed without considering, for example, packet loss, collisions and network failures. Before we outline the contributions of this work, we introduce already a glimpse of the basic behavior of this previously introduced system; see Figure 1. The solid line shows the fraction of active nodes over time, whereas the slashed line shows the average battery level of the nodes over time. Finally, the dotted line represents the sun power that is used to establish the amount of energy which can be harvested by the sensor arXiv:1010.4385v1 [cs.AI] 21 Oct 2010