Figure 2: Division of time between the duty-cycling mechanism and user applications. The protocol works in a sequence of time periods of length ∆. In each period, the first phase is dedicated to duty-cycling (DC), and the second phase to the user application.

inactive. This is handled via a call-back to the sensor node when it is supposed to change mode. Based on this call-back, the sensor node is then responsible for the executing the corresponding action.

Therefore, a duty-cycling algorithm has basically two functionalities: It can be enabled and disabled, and a call-back can be (un)registered to indicate changes in activity. The concept looks as follows:
c o n c e p t DutyCycling {
enum D u t y C y c l i n g A c t i v i t y {
DC ACTIVE , DC INACTIVE
};
void e n a b l e ( **void** ) ; void d i s a b l e ( **void** ) ;
template <**c l a s s** C a l l e e , **void** ( C a l l e e : : ∗ TMethod ) ( **i n t**)>
i n t r e g c h a n g e d c a l l b a c k ( C a l l e e ∗ o b j p n t )
void u n r e g r e c v c a l l b a c k ( **i n t** ) ;
};
With the aid of this generic concept, it is possible to cover a broad range of duty-cycling algorithms. The exact behavior of a potential duty-cycling model is not mandatory. It can be asynchronous or synchronized, it may rely on exact time-synchronization or do not have any requirements. The important aspect is that the method signatures from the concept are implemented, so that it can be passed to other algorithms as a template parameter.

## 3 Proposed Duty-Cycling Model

As mentioned before, in [8, 7, 6] a swarm intelligence technique with the potential application of selfsynchronized duty-cycling in (mobile) wireless sensor networks with energy harvesting capabilities was introduced. This section aims at designing and implementing a duty-cycling protocol on the basis of this work. The current version of the protocol assumes that there is a time synchronization algorithm executed by a lower layer of the network. The protocol works in periods. Each period has a length of ∆ time units (say, seconds). Each period is divided in two phases: the first phase is dedicated to actions concerning the management of duty-cycling, whereas the second phase is dedicated to application-specific tasks that sensor nodes must perform (see Figure 2). The first phase of each period is very short. In this phase all nodes may receive transmissions from neighboring nodes and themselves they execute one duty-cycling event. The outcome of the first phase decides if a node will be active or *inactive* for the rest of the corresponding period. In case of being active a node is available for user-defined applications (environmental data monitoring, tracking, etc). However, if the state of a sensor node is set to inactive the node will turn off the radio and will sleep until the start of the following period.

In the following we focus on the description of the duty-cycling algorithm executed in the first phase of each period. This algorithm consists in a so-called *duty-cycling event* that is executed by each sensor node i exactly once. The time of executing this event is, at the moment, randomly chosen by each sensor node within the first phase of each period. Each sensor node i maintains a real-valued