state variable Si. The value of this state variable is initially set to the so-called *activity threshold* Sact, which is a parameter of the mechanism. Moreover, aiis a binary variable whose value determines if the sensor node i is *active* (ai = 1) or *inactive* (ai = 0) in phase of two of the corresponding period. The value of the variable aiis determined as follows:

$$a_{i}:=\Phi(S_{i}-\theta_{\mathrm{act}})\;\;,$$
$$(1)$$
ai:= Φ(Si − θact) , (1)
where θact is the so-called activation threshold, and Φ(x) = 1 if x ≥ 0, and Φ(x) = 0 otherwise. Note that an inactive sensor node can return to the active state either due to local interactions (as explained below in Eq. 2) or spontaneously with a probability pa and an activity level Sa.

In addition, each sensor node maintains a queue Qi for incoming duty-cycling messages from neighboring sensor nodes. Each message m ∈ Qi contains a single field mactivity, which is set to the activity Sj of the sensor node j that has sent the message. When sensor node i executes its dutycycling event, the value of state variable Siis updated depending on the messages in Qi. Subsequently sensor node i sends a duty-cycling message, containing the new value of Si, using a certain transmission power level. Note that the choice of the transmission power level is a crucial component for the working of our duty-cycling technique. More specifically, the value of state variable Si of a sensor node i is computed as follows:

$$S_{i}:=t a n h(g\cdot(S_{i}+\sum_{m\in Q_{i}}m_{\mathrm{activity}}))\;\;,$$
$$\mathbf{\Omega}(2)$$

where g is a gain parameter whose value determines how fast the value of variable Si diminishes. After this update, all messages are deleted from Qi, that is Qi:= ∅. Note that with this update the value Si of an inactive sensor may increase sufficiently enough in order to be greater than the activity
threshold Sact.
For the working of the duty-cycling mechanism, the choice of the power level for the transmission
of the duty-cycling messages plays a crucial role. Here we assume a standard antenna model which
allows sensor nodes—for each transmission—to choose from a finite set P = {P
1**, . . . , P** n} of different transmission power levels.1 More specifically, the choice of a sensor node i depends on its battery
level, which is denoted by bi ∈ [0, 1]. Hereby, bi = 1 corresponds to a full battery. In the following
we first outline the determination of a so-called *ideal transmission power level*, which then leads to
the choice of the real transmission power level. The ideal transmission power level (pi) of a sensor i depends on the current battery level: pi:= pmin · (1 − bi) + pmax · bi, where pmin, respectively pmax,
are parameters that fix the minimum, respectively maximum, transmission power levels. Only when
batteries are fully charged the ideal transmission power level may reach pmax. The ideal transmission
power level is then translated into the *real transmission power level* (Ti) as follows: Ti:= P
k ∈ P
such that
$$p_{i}\in\Big((P^{k-1}+P^{k})/2,(P^{k}+P^{k+1})/2\Big]$$
i(3)
At this point it is important to realize that the transmission power level Tiis used only for sending the duty-cycling message. For other messages during the second phase of each period, the user application is responsible for choosing transmission power levels. The duty-cycling event described above is summarized in Algorithm 1. As mentioned above, the battery level of the sensor nodes is responsible for their choice of a transmission power level for sending the duty-cycling message. Therefore, the battery level of course affects the communication topology in the context of the duty-cycling mechanism.