
## Algorithm 1 Duty-Cycling Event Of A Sensor Node I

1: Calculate ai (see Eq. 1)
2: if ai = 0 **then**
3: Draw a random number p ∈ [0, 1]
4: if p ≤ pa **then** Si:= Sa and ai:= 1 **endif**
5: **end if**
6: Determine transmission power level Ti (see Eq. 3) 7: Compute new value for state variable Si (see Eq. 2) 8: Send duty cycling message m with mactivity := Si with transmission power level Ti

## 4 Experimental Evaluation

In the following we first describe the experimental setup and the experimentation environment before we present the obtained results. The implementation of the presented protocol in the Wiselib provides us with options for executing it on real test-beds but also to perform simulations with some sensor network simulators. In the context of this paper we decided for the second option. More specifically we used the sensor network simulator Shawn [12], which is a discrete event simulator with a very high level of parameterization which is able to execute algorithms from the Wiselib. The user can easily run experiments simulating the behavior of different sensor nodes and also add own sensor node specifications. A peculiarity of Shawn is the fact that packet collisions are not explicitly considered. Instead Shawn simulates these collisions and the consequent packet loss under different constraints and in different scenarios. Thus, any packet-loss model can be implemented.

We decided to experiment with *iSense* sensor node hardware from Coalesenses GmbH [3]. For this purpose we added the specification of *iSense* nodes to Shawn. These sensor nodes use a Jennic JN5139 chip, a solution that combines the controller and the wireless communication transceiver in a single chip. The controller has a 32-bit RISC architecture and runs at 16Mhz. It is equipped with 96kb of RAM and 128kb of serial flash. The maximum transmission power level of iSense nodes reaches a distance of about 500m in all directions in open air conditions. Note that iSense nodes are being used by two of the currently largest European projects on sensor networks: WISEBED [2, 15] and FRONTS [5]. In our simulations, iSense nodes are supposed to be equipped with solar panels. According to their documentation, iSense nodes require 0.025mA to work without using any additional peripheral such as the radio or the sensing devices. The state in which the radio is also turned on requires a power supply of 12.8mA. Additionally, to receive or send a message with 4 bytes of information, as required by duty-cycling messages, implies a consumption of 7.43µC. The batteries have a maximum capacity of 2600µC. Energy harvesting by solar panels can reach a maximum nominal value of 1.6W. This information is summarized in Table 1. Finally, let us mention that iSense nodes offer 6 possible transmission power levels, in addition to the state in which the radio is turned off. The five transmission power levels other than the maximum one are obtained by reducing the maximum transmission power level by 16
,
2 6
,
3 6
,
4 6
, and 56
.

One of the aspects that has not been described so far is the simulation of the light source for energy harvesting. This was done as follows. The light source at time z > 0 has an intensity of s(z) ∈ [0, 1].

Hereby, s(z) = 0 corresponds to absolute darkness. In [8] we described a model for the evolution of the sun light intensities, that is, for the evolution of s(z) over time. Here we consider exactly the same model. Additionally, we assume a variable cloud density c(z) ∈ [0, 1]. Depending on the technical characteristics of the solar panels used, a sensor node i can transform a fraction f of the available light