loss rates. A packet loss rate of ploss ∈ [0, 1] means that the probability of correctly receiving a message is 1−ploss. We repeated the initial experiment as outlined above for all packet loss rates between 0 and 1, in steps of 0.01. The results are shown in terms of the obtained *mean system activity* for each considered packet loss rate in Figure 4 (top). It can be observed that the behavior of the system does not visibly change until a packet loss rate of about 0.3. This means that the proposed system is quite robust against packet loss. Only for packet loss rates greater than about 0.3 the system behavior degrades.

## 4.1.2 Limited Energy Harvesting

Another interesting question concerns the possible change in system behavior when energy harvesting is restricted. Considering the example of solar panels, this is the case, for example, with bad weather conditions. Remember that the proposed model is able to simulate bad weather conditions by means of cloud densities greater than zero. We repeated the initial experiment (that is, without considering packet loss) for a range of different cloud densities between 0 and 1. Figure 4 (middle) shows the evolution of the obtained mean system activity when moving from low to high cloud densities. As expected, with increasing cloud density the mean system activity decreases. Interestingly, the relation between cloud density and the mean system activity is linear.

## 4.1.3 Adapting To Different Network Sizes

When changing to differently sized networks (we only considered 120 node networks so far), it is intuitively clear that some parameter values must be adjusted in order to maintain a functional system.

Note that when changing the network size, the node density changes. Hence, it is reasonable to assume that for maintaining the shape of the activity peaks, the choice of the transmission power level and the probability of spontaneous activation should be adapted to the new network size. A way of obtaining the new system parameters is described in the following. With knew, p a new and t new we refer to the new number of sensor nodes, the probability of spontaneous activation and the transmission power level of the new, differently sized, network. First, in order to obtain the same wake-up rates as in the case of a 120-node network, the following rule can be applied: p a new := p a· k/knew, where p aand k are the parameters from the original network. Note that this rule increases the probability of spontaneous activation of the nodes when the network size is decreased, and vice-versa when the number of nodes increases. Moreover, the average number of nodes' spontaneous activations per time unit is maintained. Next we introduce a rule for adapting the transmission power level. The basic idea is to have a constant average number of sensors being reached by a transmission. Due to the fact that the sensor nodes form a random topology, the following reasoning was used. In general, the number of nodes that can be reached by the ideal transmission of a sensor can be estimated as follows:
π · t · 2 · k/S, where k is the number of sensor nodes and S is the space in which the sensor nodes reside. In our case it holds that S = 12 = 1. Therefore, this term reduces to π · t · 2 · k. As t is known for the case of 120-node networks, an adjusted transmission power level can be calculated for networks of different sizes as follows:

$$t^{\mathrm{new}}={\sqrt{\frac{t\cdot2\cdot k}{k_{\mathrm{new}}}}}\ ,$$
, (6)
where knew is the size, respectively t new is the transmission power level, of the new network. However, note that the transmission power level is not directly modifiable as an algorithm parameter. The only parameters of our algorithm for what concerns to the transmission power level are pmin and

$$(6)$$
