
## 3 Conditional Forms Of Interchangeability

Conditions can be added to a CSP in the form of constraints that further constrain the problem. In problems with little interchangeability, such conditions can be imposed to increase the interchangeability among the variable values.

In [2004], Zhang and Freuder introduced and studied conditional interchangeability, conditional substitutability, conditional neighborhood interchangeability and conditional neighborhood substitutability.

Conditional Interchangeability (ConI) [Zhang and Freuder, 2004] Two values a and b of variable v are ConI under a condition imposed by a set of additional constraints iff they are FI in the problem with the additional constraints.

Similarly Conditional Neighborhood Interchangeability (ConNI), Conditional Substitutability (ConSub), and Conditional Neighborhood Substitutability (ConNSub)
are defined by [Zhang and Freuder, 2004] where a problem is NI, Sub and NSub respectively given a set of conditions. Theorem 13. (ConNI → ConI → ConSub), (ConNI → ConNSub → ConSub), and ConI and ConNSub are not comparable.

For ConNI → ConI and ConNSub → ConSub, see [Zhang and Freuder, 2004].

Consider the local forms: ConNI → ConNSub. For the same set of additional constraints, if a and b are ConNI in the original problem, they are NI in the problem with the additional constraints. Hence, they are also NSub in the problem with the additional constraints, and ConNSub in the original problem. The proof for the global forms (i.e., ConI → ConSub) is similar. Similar to the noncomparability of FI and NSub (see Theorem 5), ConI and ConNSub can be shown to be not comparable.

## 4 Other Forms Of Interchangeability

In this section we review other forms of interchangeability that have appeared in the literature.

Neighborhood Tuple Interchangeability (NTI) [Neagu and Faltings, 1999].

Values a and b for variable v are NTI with respect to a set of variables S if for every consistent tuple t of value assignments to S ∪ {v} where x = a there is another consistent tuple t 0 where v = b such that t and t 0 are consistent with the same value combinations for variables outside of S. Additionally, the same condition must hold when a and b are exchanged. Figure 12 shows an example.

The algorithm proposed in [Neagu and Faltings, 2005] to detect NTI values determines the smallest set S using discrimination trees. The complexity of detecting NTI values is O((n smax smax(n − smax)d 4), where n is the number of variables, d is the maximum domain size, and smax is the maximum size of all possible dependent sets in the neighborhood of the variable.

Theorem 14. NI → NTI → PI and NTI → NPI.