
## 5 Applications

In this section we survey applications, where concept drift problem is relevant in both supervised and unsupervised learning. We present the real life problem, discuss the sources of a drift and the actual learning tasks in the context of these problems.

We find four general types of applications: monitoring control, personal assistance, decision making and artificial intelligence. *Monitoring and control* often employs unsupervised learning, which detects abnormal behavior. It includes detection of adversary activities on the web, computer networks, telecommunications, financial transactions. *Personal assistance and information* applications include recommender systems, categorization and organization of textual information, customer profiling for marketing. *Decision making* includes diagnostics, evaluation of creditworthiness.

The 'ground truth' is usually delayed, i.e. the true answer whether the decision was correct becomes available only after certain time. *Artificial intelligence* applications include a wide spectrum of moving and stationary systems, which interact with changing environment, for instance robots, mobile vehicles, smart household appliances. We define five dimensions, relevant to the applications facing concept drift:
1. the speed of learning and output,

2. classification or prediction accuracy, 3. costs of mistakes, 4. true labels, 5. adversary activities.
The speed of learning output means what is a relative volume of data and how fast the decision needs to be made. For example, in credit card fraud detection the decision needs to be fast to stop the crime and the data loads are huge, while in credit evaluation a decision regarding the credit can be made even in a few days time. In both cases adversary activities to cheat the system might be expected, while adversary activities in diagnostics would make less sense. The precise accuracy in diagnostics is generally much more significant than in movie recommendations, moreover, in movie recommendations the decision might be 'soft' in a sense the viewer is not always deterministic, which movie he or she liked more.

Our global interpretation of the four types of applications in accord with these dimensions is provided in Table 2.

| Table 2: Types of applications with concept drift. Decision Accuracy Costs of   | Labels   | Adversary   |        |         |          |
|---------------------------------------------------------------------------------|----------|-------------|--------|---------|----------|
| speed                                                                           | mistakes |             |        |         |          |
| 1. Monitoring & control                                                         | high     | approximate | medium | hard    | active   |
| 2. Assistance & information                                                     | medium   | approximate | low    | soft    | low      |
| 3. Decision making                                                              | low      | precise     | high   | delayed | possible |
| 4. AI and robotics                                                              | high     | precise     | high   | hard    | low      |
