
## 2.2 Change Types

In Section 1.2 we identified the causes of a drift, or what happens to the data generating source itself. Here by change types we mean the configuration patterns of the data sources over time. The structural types of change are usually defined based on those configurations.

For intuitive explanation, let us for now restrict the number of possible sources over time to two:
SI and SII . The simplest pattern of a change is *sudden drift*, when at time t0 a source SI is suddenly replaced by source SII . For example, Kate is reading the news. Sudden interest in meat prices in New Zealand when she got an assignment to write an article, is a sudden drift. Gradual drift is another type often met in the literature. However in fact there are two types being mixed under this term. The first type of gradual drift is referring to a period when both sources SI
and SII are active (e.g. [141, 154, 112]). As time passes, the probability of sampling from source SI decreases, probability of sampling from source SII increases. Note, that at the beginning of this gradual drift, before more instances are seen, an instance from the source SII might be easily mixed up with random noise. Another type of drift also referred as gradual includes more than two sources, however, the difference between the sources is very small, thus the drift is noticed only when looking at a longer time period (e.g. [148, 37, 5]). We refer to the former type of gradual drift as *gradual* and the latter type of drift as *incremental* (or stepwise). For example, gradual drift is increasing interest in real estate, while Kate prefers real estate news more and more over time when her interest in buying a flat increases.

Finally, there is another big type of drift referred as *reoccurring context*. That is when previously active concept reappears after some time. It differs from common seasonality notion in a way that it is not certainly periodic, it is not clear when the source might reappear. In Kate's example these are the biographies of Formula-1 drivers. The interest is related to the schedule of the races. But she does not look up the biographies at the time of the races, because she is watching them at the time. She might want to look up them later in the middle of the week. And the particular drivers she will be interested in might depend on who won the races this time.

In Figure 4 we give an illustration of the main structural drift types, assuming one dimensional data, where a source is characterized by the mean of the data. We depict only the data from one class. Note that the types of drifts discussed here are not exhaustive. If we think of a data segment of length t and just two data generating sources SI and SII , the number of possible combinations of the sources (that means possible change patterns) would be 2t, a lot. Moreover, in concept drift research it is often assumed that the data stream is endless, thus there could be infinite number of possible change patterns. We define the major structural types, since we argue, that assumption about the change types is absolutely needed for designing adaptivity strategies.

Recently there has been an attempt to categorize change types into mutually exclusive categories
[108] based on number of reoccurences, severity, speed and predictability. In principle the proposed categorization tires to quantify the main aspects of the learner design process into change categorization. We argue that the categories cannot be mutually exclusive, because the change frequency