It is common to categorize concept drift learners into two major groups:
1. learner adaptivity is initiated by a *trigger* (or active change detector), and 2. a learner regularly *evolves* independently of the alarms or detectors.

The two categories can be positioned within the design framework we just defined. In the first group the initiation for learner adaptivity comes from the 'change type' block, while in the second group the adaptivity is based on 'model evaluation and selection' block. The process is illustrated in Figure 5 (b).

We will give more details about the categories of the drift learners in the next section, where we overview the related work.

## 3 Taxonomy Of Available Concept Drift Learners

In this section we overview and map the related work. This section is intended to give a general view, the approaches specifically related to our work will be presented in corresponding chapters.

The overview is concentrated on a supervised learning under concept drift. Schlimmer and Granger [136] in 1986 formulated the problem of incremental learning from noisy data and presented an adaptive learning algorithm STAGGER. They are the authors of the term 'concept drift'. Since then a number of studies dealing with concept drift problem appeared. There were three 'peaks' in interest, one around 1998 followed by a special issue of Machine Learning journal [38], the other around 2004 followed by a special issue of Intelligent Data Analysis journal [88]. The third 'peak' started around 2007 and continues now on, as a result of increasing loads of streaming data and computational resources. Several PhD theses have directly addressed the problem of concept drift [12, 113, 155, 26, 140].

The learners responsive to a concept drift can be divided into two big groups based on *when* the adaptivity is 'switched on'. They are either trigger based or evolving. Trigger based means that there is a signal which indicates a need for model change. The trigger directly influences how the new model should be constructed. Most often change detectors are employed as triggers.

The evolving methods on the contrary do not maintain an explicit link between the data progress and model construction and usually do not detect changes. They aim to build the most accurate classifier either by maintaining the ensemble weights or prototyping mechanisms. They usually keep a set of alternative models, and the models for a particular time point are selected based on their performance estimation. This is 'why' dimension in the taxonomy. Another dimension for grouping concept drift learners is based on how the learners adapt. What are the actual adaptation mechanisms? The mechanisms were discussed following the design assumption A.4 presented in Section 2. Generally the adaptation mechanisms are either related to training set formation or a design and parametrization of the base learner.

Based on those two dimensions we overview the main methodological contributions available in the literature. The taxonomy is graphically presented in Figure 6. The positions of popular techniques (our interpretation) are indicated by ellipses.