To facilitate the comparison with the maximum entropy unfolding algorithm we now introduce an alternative approach to enforcing translation invariance. Our approach generalizes the LLE algorithm. First of all we introduce a new matrix M. We define off diagonal elements of this matrix to be given by W so we have mj,i = wj,i for i 6= j. We set the diagonal elements of M to be the negative sum of the off diagonal columns, so we have mi,i = −Pj∈N(i) wj,i.

We can then rewrite the objective in (7) as,

$$E(\mathbf{w}_{:,i})={\frac{1}{2}}\left\|\mathbf{Y}^{\top}\mathbf{m}_{:,i}\right\|_{2}^{2}=\mathbf{m}_{:,i}^{\top}\mathbf{Y}\mathbf{Y}^{\top}\mathbf{m}_{:,i},$$

which is identical to (7) if mi,i is further constrained to 1. However, even if this constraint isn't imposed, the translational invariance is retained. This is clear if we rewrite the objective in terms of the non-zero elements of m:,i,

 $$E(\mathbf{w}_{:,i})=\frac{m_{i,i}^2}{2}\left\|\mathbf{y}_{i,:}+\sum_{j\in\mathcal{N}(i)}\mathbf{y}_{j,:}\frac{m_{j,i}}{m_{i,i}}\right\|_2^2$$ $$=\frac{m_{i,i}^2}{2}\left\|\mathbf{y}_{i,:}-\sum_{j\in\mathcal{N}(i)}\mathbf{y}_{j,:}w_{j,i}\right\|_2^2$$  $$w_{j,i}=-\frac{m_{j,i}}{m_{i,i}}$$  Does this result I do not see that up to a zero? 
where and by definition of mi,i we have Pj∈N(i) wj,i = 1. We now see that up to a scalar factor, m2 i,i, this equation is identical to (7).

This form of the objective also shows us that mi,i has the role of scaling each data point's contribution to the overall objective function (rather like the degree, vi,i would do in the unnormalized variant of Laplacian eigenmaps we discussed in Section 2.6.2).

The objective function is a least squares formulation with particular constraints on the regression weights, m:,i.

As with all least squares regressions, there is an underlying probabilistic interpretation of the regression which suggests Gaussian noise. In our objective function the variance of the Gaussian noise for the ith data point is given by m−2 i,i . We can be a little more explicit about this by writing down the error as the negative log likelihood of the equivalent Gaussian model. This then includes a normalization term, log m2 i,i, which is zero in standard LLE where m2 i,i = 1,

$$E(\mathbf{w}_{:,i})=-\log\mathcal{N}\left(\mathbf{y}_{i,:}\Big{|}\sum_{j\in\mathcal{N}(i)}\mathbf{y}_{j,:}\hat{m}_{j,i},m_{i,i}^{-2}\right)$$ $$=\frac{m_{i,i}^{2}}{2}\left\|\mathbf{y}_{i,:}-\sum_{j\in\mathcal{N}(i)}\mathbf{y}_{j,:}\hat{m}_{j,i}\right\|_{2}^{2}-\frac{1}{2}\log m_{i,i}^{2}+\text{const}$$ $$=\frac{1}{2}\mathbf{m}_{:,i}^{\mathsf{T}}\mathbf{Y}\mathbf{Y}^{\mathsf{T}}\,\mathbf{m}_{:,i}-\frac{1}{2}\log m_{i,i}^{2}+\text{const}.$$
$$\left(8\right)$$
$$({\mathfrak{g}})$$

The overall objective is the sum of the objectives for each column of W. Under the probabilistic interpretation this
is equivalent to assuming independence between the individual regressions. The objective can be written in matrix
form as
$$E(\mathbf{W})={\frac{1}{2}}\sum_{i=1}^{n}\mathbf{m}_{:,i}^{\top}\mathbf{YY}^{\top}\mathbf{m}_{:,i}-{\frac{1}{2}}\sum_{i=1}^{n}\log m_{i,i}^{2}+\mathrm{const}.$$
i,i + const. (9)
Recalling that our definition of M was in terms of W, we now make that dependence explicit by parameterizing the objective function only in terms of the non-zero elements of W. To do this we introduce a 'croupier matrix' Si ∈ <n×ki, where kiis the size of the i data point's neighborhood. This matrix will distribute the non-zero elements of W appropriately into M. It is defined in such a way that for the ith data point we have m:,i = Siwi, where we use the shorthand wi = wN(i),i. In other words wiis the vector of regression weights being used to reconstruct the ith data point. It contains the non-zero elements from the ith column of W. The matrix Siis constructed by setting all elements in its ith row to −1 (causing mi,i to be the negative sum of the elements of wi as defined).