does factorize into n independent regression problems,

$$\log p(\mathbf{Y})=\frac{\left|\mathbf{M}\mathbf{M}^{\top}\right|^{\frac{1}{2}}}{\tau^{\frac{n}{2}}}\exp\left(-\frac{1}{2}\mathrm{tr}\left(\mathbf{Y}\mathbf{M}\mathbf{M}^{\top}\right)\right)$$ $$=\prod_{i}^{n}\frac{m_{i,i}^{2}}{\tau^{\frac{1}{2}}}\exp\left(-\frac{m_{i,i}^{2}}{2}\left\|\mathbf{y}_{i,:}+\sum_{j\in\mathcal{N}(i)}\frac{m_{j,i}}{m_{i,i}}\mathbf{y}_{j,:}\right\|_{2}^{2}\right).$$

The representation corresponds to a Gaussian random field which is constructed from specifying the directed relationship between the nodes in the graph. We can derive the Gaussian random field by considering a series of conditional relationships,

## P(Yi,:|Y\I) = P(Yi,:|Yj>I,:)

where our notation here is designed to indicate that the model is constrained so that the density associated with each data point, yi,:, is only dependent on data points with an index greater than i, a matrix we denote with Y*j>i,*:. This constraint is enforced by our demand that the only potential neighbors (parents in the directed graph)
are those data points with an index greater than i. The undirected system can now be produced by taking the conditional densities of each data point,

$$p(\mathbf{y}_{i,:}|\mathbf{Y}_{j>i,:})={\mathcal{N}}\left(\mathbf{y}_{i,:}|\mathbf{Y}_{j>i,:}^{\mathsf{T}}\mathbf{m}_{j>i,i},m_{i,i}^{-2}\mathbf{I}\right),$$

and multiplying them together,

$$p(\mathbf{Y})=\prod_{i=1}^{n}p(\mathbf{y}_{i,:}|\mathbf{Y}_{j>i,:}),$$

to form the joint density. Note that the nth data point has no parents so we can write p(yn,:|Y*j>n,*:) = p(yn,:).

However, since we defined mj,j = −Pi>j mi,j the model as it currently stands associates an infinite variance with this marginal density (mn,n = 0). This is a consequence of the constraint M>1 = 0. The problem manifests itself when computing the log determinant of L, logMM> =Pi log m2 i,i to develop the log likelihood. The last term in this sum is now log m2n,n = log 0. As for the standard model this is resolved if we include the γI term from the base density when computing the determinant, but this destroys the separability of the determinant computation.

If the likelihood is required the value mn,n could be set to a small value, or optimized, relaxing the constraint on M.

We call the algorithm based on the above decomposition acyclic locally linear embedding (ALLE). A weakness for the ALLE is the need to specify an ordering for the data. The ordering specifies which points can be neighbors and different orderings will lead to different results. Ideally one might want to specify the sparsity pattern in L
and derive the appropriate sparsity structure for M. However, given a general undirected graph it is not possible, in general, to find an equivalent directed acyclic graph. This is because co-parents in the directed graph gain an edge in the undirected graph, but the weight associated with this edge cannot be set independently of the weights associated with the edges between those co-parents and their children.

## 2.7.5 Lle And Pca

LLE is motivated by considering local linear embeddings of the data, although interestingly, as we increase the neighborhood size to K = n − 1 we do not recover PCA, which is known to be the optimal linear embedding of the data under linear Gaussian constraints. The fact that LLE is optimizing the pseudolikelihood makes it clear why this is the case. In contrast the MEU algorithm, which LLE approximates, does recover PCA when K = n − 1.

The ALLE algorithm also recovers PCA.

## 2.8 Relation To Isomap

The isomap algorithm [Tenenbaum et al., 2000] more directly follows the CMDS framework. In isomap [Tenenbaum et al., 2000] a sparse graph of distances is created between all points considered to be neighbors. This graph is then filled in for all non-neighboring points by finding the shortest distance between any two neighboring points in the graph (along the edges specified by the neighbors). The resulting matrix is then element-wise squared to give a matrix of square distances which is then processed in the usual manner (centering and multiplying by -0.5) to provide a similarity matrix for multidimensional scaling. Compare this to the situation for MVU and MEU. Both MVU and