MEU can be thought of as starting with a sparse graph of (squared) distances. The other distances are then filled in by either maximizing the trace of the associated covariance or maximizing the entropy. Importantly, though, the interneighbor distances in this graph are preserved (through constraints imposed by Lagrange multipliers) just like in isomap. For both MVU and MEU the covariance matrix, K, is guaranteed positive semidefinite because the distances are implied by an underlying covariance matrix that is constrained positive definite. For isomap the shortest path algorithm is effectively approximating the distances between non-neighboring points. This can lead to an implied covariance matrix which has negative eigenvalues [see Weinberger et al., 2004]. The algorithm is still slower than LLE and Laplacian eigenmaps because it requires a dense eigenvalue problem and the application of a shortest path algorithm to the graph provided by the neighbors.

## 3 Estimating Graph Structure

The relationship between spectral dimensionality reduction algorithms and Gaussian random fields now leads us to consider a novel approach to dimensionality reduction. Recently it's been shown that the structure of a Gaussian random field can be estimated through using L1 shrinkage on the parameters of the inverse covariance [see Hastie et al., 2009, Chapter 17]. These sparse graph estimators are attractive as the regularization allows some structure determination. In other words, rather than relying entirely on the structure provided by the K nearest neighbors in data space, we can estimate this structure from the data. We call the resulting class of approaches Dimensionality reduction through Regularization of the Inverse covariance in the Log Likelihood (DRILL).

Before introducing the method, we need to first re-derive the maximum entropy approach by constraining the second moment of neighboring data points to equal the empirical observation instead of the expected inter data point squared distances. We first define the empirically observed second moment observation to be

$$\mathbf{S}=\mathbf{YY}^{\top}$$

so if two points, i and j are neighbors then we constrain

$$s_{i,j}=\left\langle\mathbf{y}_{i,:}^{\top}\mathbf{y}_{j,:}\right\rangle,$$
here $s_{i,j}$ is the $i,j$th ele
where si,j is the *i, j*th element of S. If we then further constrain the diagonal moments,

$$\langle\mathbf{y}_{i,:}^{\top}\mathbf{y}_{i,:}\rangle=s_{i,i}$$
$$\left(12\right)$$
$\mathbf{s}$, will be given by . 
= si,i (12)
then the expected squared distance between two data points, will be given by

$$\langle d_{i,j}\rangle=\left\langle\mathbf{y}_{i,:}^{\top}\mathbf{y}_{i,:}\right\rangle-2\left\langle\mathbf{y}_{i,:}^{\top}\mathbf{y}_{j,:}\right\rangle+\left\langle\mathbf{y}_{j,:}^{\top}\mathbf{y}_{j,:}\right\rangle=s_{i,i}-2s_{i,j}+s_{j,j}.$$

So the expected interpoint squared distance will match the empirically observed interpoint squared distance from the data. In other words, whilst we've formulated the constraints slightly differently, the final model will respect the same interpoint squared distance constraints as our original formulation of maximum entropy unfolding.

The maximum entropy solution for the distribution has the form

$$p(\mathbf{Y})\propto\exp\left(-{\frac{1}{2}}\mathrm{tr}\left(\mathbf{YY}^{\top}(\mathbf{A}+\gamma\mathbf{I})\right)\right),$$

where now the matrix of Lagrange multipliers matches the sparsity structure of the underlying neighborhood graph but also contains diagonal elements to enforce the constraint from (12). Writing the full log likelihood in terms of the matrix S we have

$$\log p(\mathbf{Y})=-{\frac{p n}{2}}\log\tau+{\frac{p}{2}}\log|\mathbf{\Lambda}+\gamma\mathbf{I}|-{\frac{1}{2}}\mathrm{tr}\left(\mathbf{S}(\mathbf{\Lambda}+\gamma\mathbf{I})\right),$$

Once again, maximum likelihood in this system is equivalent to finding the Lagrange multipliers so, given the structure from the neighborhood relationships, we simply need to maximize the likelihood to solve the system.

That will lead to an implied covariance matrix,

$$\mathbf{K}=(\mathbf{\Lambda}+\gamma\mathbf{I})^{-1},$$

which once again should be centred, B = HKH, and the principal eigenvectors extracted to visualize the embedding.

Here, though, we are proposing some additional structure learning. If elements of the inverse covariance are regularized appropriately the model can perform some additional structure learning. In particular recent work on