

![0_image_0.png](0_image_0.png) 

Given a data set with n data points and p features associated with each data point, dimensionality reduction involves representing the data set using n points each with a reduced number, q, of features, with *q < p*. Dimensionality reduction is a popular approach to dealing with high dimensional data: the hope is that while many data sets seem high dimensional, it may be that their intrinsic dimensionality is low like the rotated six above.

## 1.1 Spectral Dimensionality Reduction

Spectral approaches to dimensionality reduction involve taking a data set containing n points and forming a matrix of size n × n from which eigenvectors are extracted to give a representation of the data in a low dimensional space.

Several spectral methods have become popular in the machine learning community including isomap [Tenenbaum et al., 2000], locally linear embeddings [LLE, Roweis and Saul, 2000], Laplacian eigenmaps [Belkin and Niyogi, 2003] and maximum variance unfolding [MVU, Weinberger et al., 2004]. These approaches (and kernel principal component analysis [kernel PCA, Sch¨olkopf et al., 1998]) are closely related to classical multidimensional scaling [CMDS, Mardia et al., 1979]. For a kernel perspective on the relationships see Ham et al. [2004], Bengio et al. [2004b,a].

In classical multidimensional scaling an n × n symmetric distance matrix, whose elements contain the distance between two data points, is converted to a similarity matrix and visualized through its principal eigenvectors.

Viewed from the perspective of CMDS the main difference between the spectral approaches developed in the machine learning community is in the distance matrices they (perhaps implicitly) proscribe.

In this paper we introduce a probabilistic approach to constructing the distance matrix: maximum entropy unfolding (MEU). We describe how isomap, LLE, Laplacian eigenmaps and MVU are related to MEU using the unifying perspective of Gaussian random fields and CMDS.

The parameters of the model are fitted through maximum likelihood in a Gaussian Markov random field (GRF).

The random field specifies dependencies between *data points* rather than the more typical approach which specifies dependencies between *data features*. We show that the locally linear embedding algorithm is an approximation to maximum entropy unfolding where pseudolikelihood is maximized as an approximation to the model likelihood. Our probabilistic perspective inspires new dimensionality reduction algorithms. We introduce an exact version of locally linear embedding based on an acyclic graph structure that maximizes the true model likelihood (acyclic locally linear embedding, ALLE). We also consider approaches to learning the structure of the GRF through graphical regression, [Friedman et al., 2008]. By L1 regularization of the dependencies we explore whether learning the graph structure (rather than prespecifying by nearest neighbour) improves performance. We call the algorithm Dimensionality reduction through Regularization of the Inverse covariance in the Log Likelihood (DRILL).