Our methods are based on maximum likelihood. Normally maximum likelihood algorithms specify a distribution which factorizes over the data points (each data point is independent given the model parameters). In our models the likelihood factorizes over the features (each feature from the data set is independent given the model parameters).

This means that maximum likelihood in our model is consistent as the number of features increases, p → ∞ rather than the number of data points. Alternatively, the parameters of our models become better determined as the number of features increase, rather than the number of data. This leads to a *blessing* of dimensionality where the parameters are better determined as the number of features increases. This has significant implications for learning in high dimensional data (known as the large p small n regime) which run counter to received wisdom.

In Section 2 we derive our model through using standard assumptions from the field of dimensionality reduction and the maximum entropy principle [Jaynes, 1986]. We then relate the model to other popular spectral approaches for dimensionality reduction and show how the parameters of the model can be fitted through maximum likelihood.

This allows us to regularize the system with sparse priors and seek MAP solutions that restrict the inter point dependencies. Finally, we demonstrate the model (with comparisons) on two real world data sets. First though, we will review classical multidimensional scaling which provides the general framework through which these approaches can be related [see also Ham et al., 2004, Bengio et al., 2004b,a].

## 1.2 Classical Multidimensional Scaling

Given an n × n matrix of similarities, K, or dissimilarities, D, between a set of data points, multidimensional scaling considers the problem of how to represent these data in a low dimensional space. One way of doing this is to associate a q dimensional latent vector with each data point, yi,:, and define a set of dissimilarities between each latent point, δi,j = kxi,: − xj,:k 2 2
(where k·k2 represents the L2-norm) to give a matrix ∆. Here we have specified the squared distance between each point as the dissimilarity.1 If the error for the latent representation is then taken to be the sum of absolute values between the dissimilarity matrix entries,

$$E({\bf X})=\sum_{i=1}^{n}\sum_{j=1}^{i-1}\left\|d_{i,j}-\delta_{i,j}\right\|_{1},\tag{1}$$
$$(1)$$

and we assume that the data dissimilarities also represent a squared Euclidean distance matrix (perhaps computed in some high, maybe infinite, dimensional space) then the optimal *linear* dimensionality reduction is given by the following procedure [Mardia et al., 1979, pg 400],

1. Convert the matrix of dissimilarities to a matrix of similarities by taking B = −
1 2HDH where H = I−n
−111>
is a centering matrix.

2. Extract the first q principal eigenvectors of B. 3. Setting X to these principal eigenvectors (appropriately scaled) gives a global minimum for the error function
(1).
The centering matrix H is so called because when applied to data in the form of a design matrix, Y, i.e. one where each row is a data point and each column is a data set feature, the centred data matrix is recovered,

Yˆ =YH
$$\begin{array}{r l}{\mathbf{\tau}=\mathbf{Y}-n^{-1}\mathbf{Y11}^{\top},}\\ {\mathbf{\tau}=\mathbf{Y}-\mu\mathbf{1}^{\top}}\end{array}$$
where µ = n
−1Y1 is the empirical mean of the data set.

## 2 Maximum Entropy Unfolding

Classical multidimensional scaling provides the optimal *linear* transformation of the space in which the squared distances are expressed. The key contribution of recently developed spectral approaches in machine learning is to compute these distances in a space which is nonlinearly related to the data thereby ensuring a *nonlinear* dimensionality reduction algorithm. From a machine learning perspective this is perhaps clearest for kernel PCA [Sch¨olkopf 1It is more usual to specify the distance directly as the dissimilarity, however, for our purposes it will be more convenient to work with squared distances