
## 2.2 Maximum Entropy In Continuous Systems

The entropy of a continuous density is normally defined as the limit of a discrete system. The continuous distribution is discretized and we consider the limit as the discrete bin widths approach zero. However, as that limit is taken the a term dependent on the bin width approaches ∞. Normally this is dealt with by ignoring that term and referring to the remaining term as differential entropy. However, the maximum entropy solution for this differential entropy turns out to be undefined. Jaynes proposes an alternative *invariant measure* to the entropy. For maximum entropy in continuous systems we maximize the negative Kullback Leibler divergence [KL divergence, Kullback and Leibler, 1951] between a base density, m(Y), and the density of interest, p(Y),

$$H=-\int p(\mathbf{Y})\log{\frac{p(\mathbf{Y})}{m(\mathbf{Y})}}\mathrm{d}\mathbf{Y}.$$

Maximizing this measure is equivalent to minimizing the KL divergence between p(Y) and the base density, m(Y).

Any choice of base density can be made, but the solution will be pulled towards the base density (through the minimization of the KL divergence). We choose a base density to be a very broad, spherical, Gaussian density with covariance γ
−1I. This adds a new parameter, γ, to the system, but it will turn out that this parameter has little affect on our analysis. Typically it can be taken to zero or assumed small. The density that minimizes the KL
divergence under the constraints on the expectations is then

$$p(\mathbf{Y})\propto\exp\left(-{\frac{1}{2}}\mathrm{tr}\left(\gamma\mathbf{YY}^{\top}\right)\right)\exp\left(-{\frac{1}{2}}\sum_{i}\sum_{j\in{\mathcal{N}}(i)}\lambda_{i,j}d_{i,j}\right),$$

where N (i) represents the set of neighbors of data point i, and Y = [y1,:*, . . . ,* yn,:]
> ∈ <n×pis a *design matrix* containing our data. Note that we have introduced a factor of −1/2 in front of our Lagrange multipliers, {λi,j}, for later notational convenience. We now define the matrix Λ to contain λi,j if i is a neighbor of j and zero otherwise.

This allows us to write the distribution3 as

$$p(\mathbf{Y})\propto\exp\left(-{\frac{1}{2}}\mathrm{tr}\left(\gamma\mathbf{YY}^{\top}\right)-{\frac{1}{4}}\mathrm{tr}\left(\mathbf{AD}\right)\right).$$

We now introduce a matrix L, which has the form of a graph Laplacian. It is symmetric and constrained to have a null space in the constant vector, L1 = 0. Its off diagonal elements are given by −Λ and its diagonal elements are given by

$$\ell_{i,i}=\sum_{j\in{\mathcal{N}}(i)}\lambda_{i,j}$$

to enforce the null space constraint. The null space constraint enables us to write

$$p({\bf Y})=\frac{|{\bf L}+\gamma{\bf I}|^{\frac{1}{2}}}{\tau^{\frac{\eta{\bf L}}{2}}}\exp\left(-\frac{1}{2}{\rm tr}\left(({\bf L}+\gamma{\bf I}){\bf YY}^{\top}\right)\right),\tag{3}$$

where for convenience we have defined τ = 2π. We arrive here because the distance matrix is zero along the diagonal. This allows us to set the diagonal elements of L as we please without changing the value of tr (LD). Our choice to set them as the sum of the off diagonals gives the matrix a null space in the constant vector enabling us to use the fact that

 $\mathbf{D}=\mathbf{1}\text{diag}\left(\mathbf{YY}^\top\right)^\top-\mathbf{2}\mathbf{YY}^\top+\text{diag}\left(\mathbf{YY}^\top\right)\mathbf{1}^\top$  ms a vector from the diagonal of $\mathbf{A}$) to write 
(where the operator diag (A) forms a vector from the diagonal of A) to write

$$-\operatorname{tr}\left(\mathbf{\Lambda D}\right)=\operatorname{tr}\left(\mathbf{L D}\right)=\operatorname{tr}\left(\mathbf{L d i a g}\left(\mathbf{Y Y}^{\top}\right)^{\top}-2\mathbf{L Y Y}^{\top}+\operatorname{diag}\left(\mathbf{Y Y}^{\top}\right)\mathbf{1}^{\top}\mathbf{L}\right)=-2\operatorname{tr}\left(\mathbf{L Y Y}^{\top}\right),$$

which in turn allows us to recover (3). This probability distribution is a *Gaussian random field*. It can also be written as

$$p(\mathbf{Y})=\prod_{j=1}^{p}{\frac{|\mathbf{L}+\gamma\mathbf{I}|^{\frac{1}{2}}}{\tau^{\frac{n}{2}}}}\exp\left(-{\frac{1}{2}}\mathbf{y}_{:,j}^{\top}(\mathbf{L}+\gamma\mathbf{I})\mathbf{y}_{:,j}\right),$$

which emphasizes the independence of the density across data features.

3In our matrix notation the Lagrange multipliers and distances are appearing twice inside the trace, in matrices that are constrained symmetric, Λ and D. The factor of 14 replaces the factor of 12 in the previous equation to account for this "double counting".