

![0_image_0.png](0_image_0.png)

## 2.3 Gaussian Markov Random Fields

Multivariate Gaussian densities are specified by their mean, µ, and a covariance matrix, C. A standard modeling assumption is that data is draw independently from identical Gaussian densities. For this case the likelihood of the data, p(Y), will be factorized across the individual data points,

$$p(\mathbf{Y})=\prod_{i=1}^{n}p(\mathbf{y}_{i,:})=\prod_{i=1}^{n}{\mathcal{N}}\left(\mathbf{y}_{i,:}|{\boldsymbol{\mu}},\mathbf{C}\right)$$

and the mean and covariance of the Gaussian are estimated by maximizing the log likelihood of the data. The covariance matrix is symmetric and positive definite. It contains p(p+1)
2parameters. However, if the number of data points, n, is small relative to the number of features p, then the parameters may not be well determined. For this reason we might seek a representation of the covariance matrix which has fewer parameters. One option is a low rank representation,

## C = Ww> + D,

where D is a diagonal matrix and W ∈ <p×q. This is the representation underlying factor analysis, and if D = σ 2I,
probabilistic principal component analysis [PPCA, Tipping and Bishop, 1999]. For PPCA there are pq+1 parameters in the covariance representation.

An alternative approach, and one that is particularly popular in spatial systems, is to assume a sparse *inverse* covariance matrix, known as the precision matrix, or information matrix. In this representation we consider each feature to be a vertex in a graph. If two vertices are unconnected they are conditionally independent in the graph.

In figure 2 we show a simple example graph where the precision matrix is

$$\mathbf{K}^{-1}=\mathbf{P}={\begin{bmatrix}p_{1,1}&p_{1,2}&0&0&0\\ p_{2,1}&p_{2,2}&p_{2,3}&p_{2,4}&0\\ 0&p_{3,2}&p_{3,3}&p_{3,4}&0\\ 0&p_{4,2}&p_{4,3}&p_{4,4}&0\\ 0&0&0&0&p_{5,5}\end{bmatrix}}$$
.
Zeros correspond to locations where there are no edges between vertices in the graph.

If each feature is constrained to only have K neighbors in the graph, then the inverse covariance (and correspondingly the covariance) is only parameterized by Kp + p parameters. So the GRF provides an alternative approach to reducing the number of parameters in the covariance matrix.

## 2.4 Independence Over Data Features

The Gaussian Markov random field (GRF) for maximum entropy unfolding is unusual in that the independence is being expressed over data features (in the p-dimensional direction) instead of over data points (in the n-dimensional direction). This means that our model assumes that data *features* are independently and identically distributed
(i.i.d.) given the model parameters. The standard assumption for Gaussian models is that data *points* we are expressing conditional probability densities between data points are i.i.d. given the parameters. This specification cannot be thought of as "the wrong way around" as it is merely a consequence of the constraints we chose to impose