There is perhaps a deeper lesson here in terms of how we should interpret such consistency results. In the sampled-points formalism, as we increase the number of data points, the parameters become better determined. In the sampled-features formalism, as we increase the number of features, the parameters become better determined.

However, for consistency results to hold, the class of models we consider must include the actual model that generated the data. If we believe that "Essentially, all models are wrong, but some are useful" [Box and Draper, 1987, pg 424] we may feel that encapsulating the right model within our class is a practical impossibility. Given that, we might pragmatically bias our choice somewhat to ensure utility of the resulting model. From this perspective, in the large p small n domain, the sampled-features formalism is attractive. A practical issue can arise though. If we wish to compute the likelihood of an out of sample data-point, we must first estimate the parameters associated with that new data point. This can be problematic. Of course, for the sampled-points formalism the same problem exists when you wish to include an out of sample data-feature in your model (such as in the animals example in Kemp and Tenenbaum [2008]). Unsurprisingly, addressing this issue for spectral methods is nontrivial [Bengio et al., 2004b].

## 2.5.1 Parameter Gradients

We can find the parameters, Λ, through maximum likelihood on the Gaussian Markov random field given in (3).

Some algebra shows that the gradient of each Lagrange multiplier is given by,

$${\frac{\mathrm{d}\log p(\mathbf{Y})}{\mathrm{d}\lambda_{i,j}}}={\frac{1}{2}}\left\langle d_{i,j}\right\rangle_{p(\mathbf{Y})}-{\frac{1}{2}}d_{i,j},$$

where hip(·)
represents an expectation under the distribution p(·). This result is a consequence of the maximum entropy formulation: the Lagrange multipliers have a gradient of zero when the constraints are satisfied. To compute gradients we need the expectation of the squared distance given by

$$\left\langle d_{i,j}\right\rangle=\left\langle y_{i,:}^{\top}y_{i,:}\right\rangle-2\left\langle y_{i,:}^{\top}y_{j,:}\right\rangle+\left\langle y_{j,:}^{\top}y_{j,:}\right\rangle,$$  which we can compute directly from the covariance matrix of the GRF, $\mathbf{K}=\left(\mathbf{L}+\gamma\mathbf{I}\right)^{-1}$,
$$\langle d_{i,j}\rangle=\frac{p}{2}\left(k_{i,i}-2k_{i,j}+k_{j,j}\right).$$

This is immediately recognized as a scaled version of the standard transformation between distances and similarities
(see (2)). This relationship arises naturally in the probablistic model. Every GRF has an associated interpoint distance matrix. It is this matrix that is being used in CMDS. The machine learning community might interpret this as the relationship between distances in "feature space" and the kernel function. Note though that here (and also in MVU) each individual element of the kernel matrix *cannot* be represented only as a function of the corresponding two data points (i.e. we can't represent them as ki,j = k(yi,:, yj,:), where each ki,j is a function *only* of the i and jth data points). Given this we feel it is more correct to think of this matrix as a covariance matrix induced by our specification of the random field rather than a true Mercer kernel. We use the notation ki,j to denote an element of such a covariance (or similarity matrix) and only use k(·, ·) notation when the value of the similarity matrix can be explicitly represented as a Mercer kernel.

The Base Density Parameter One role of the base density parameter, γ, is to ensure that the precision matrix is positive definite. Recall that the Laplacian has a null space in the constant vector, implying that K1 = γ
−1, which becomes infinite as γ → 0. This reflects an insensitivity of the covariance matrix to the data mean, and this in turn arises because that information is lost when we specify the expectation constraints only through interpoint distances. In practise though, K is always centred before its eigenvectors are extracted, B = HKH, resulting in B1 = 0 so γ has no effect on the final visualization. In some cases, it may be necessary to set γ to a small non-zero value to ensure stability of the inverse L + γI. In these cases we set it to γ = 1 × 10−4 but in many of the comparisons we make to other spectral algorithms below we take it to be zero. Number of Model Parameters If K neighbors are used for each data point there are O(Kn) parameters in the model, so the model is nonparametric in the sense that the number of parameters increases with the number of data. For the parameters to be well determined we require a large number of features, p, for each data point, otherwise we would need to regularize the model (see Section 3). This implies that the model is well primed for the so-called "large p small n domain".

Once the maximum likelihood solution is recovered the data can be visualized, as for MVU and kernel PCA,
by looking at the eigenvectors of the centered covariance matrix HKH. We call this algorithm maximum entropy unfolding (MEU).