
## 3. **Hierarchical Locality-Constrain Sparse** Coding Scheme 3.1 **Sparse Coding**

Sparse coding algorithms model an input cumulative foot pressure image m x R using a linear combination of basis functions that are columns of the dictionary matrix m n D R   , 
using coefficients n z R  , with n m . Previous sparse coding algorithms have been proposed in the literature and in this work we focus on the following convex formulation: 

$$L=\operatorname*{min}{\frac{1}{2}}\|x-D z\|_{2}^{2}+\lambda\sum_{i}\left|z_{i}\right|$$
   (1) 
The basic idea of sparse coding is to minimize the same objective of Eqn. 1 alternatively over coefficients z for a given dictionary D , and then over D for a given set ofz . 

## 3.2 **Locality-Constrained Sparse Coding**

As described in [22], Locality-constrained linear coding 
(LLC) introduce locality constraint instead of the sparsity constraint only, which leads to several favorable properties. Sepcifically, the LLC coding uses the following criteria: 

$$L=\operatorname*{min}{\frac{1}{2}}\|x-D z\|_{2}^{2}+\lambda\sum_{i}\left|d_{i}\odot z_{i}\right|$$

where  denotes element-wise multiplication, di is the locality adaptor that gives different freedom for each basis vector proportional to its similarity to the input cumulative foot pressure image. Different from [22], we set i d as 

$$d_{i}=d i s t(x_{i},B)$$

(,) i i *d dist x B*  (3) 
Hence, we can derive analytical solution of (2), and obtain the solution as 

$$\left\{\begin{array}{l}\tilde{z}_{i}=(Z_{i}+diag(d))\backslash1\\ \\ z_{i}=\tilde{z}_{i}/1^{T}\tilde{z}_{i},\end{array}\right.\tag{4}$$  Where $Z_{i}=(B-1x_{i}^{T})(B-1x_{i}^{T})^{T}$ denotes the data 
astrained $\quad$ S. 
covariance matrix. 
4. **Hierarchical Locality-constrained Sparse** 
Coding 

## 4.1 **Hierarchical Locality-Constrained Sparse** Coding Using Gaussian Weights

There are two terms in (2), one is optimizing the reconstruction error, another one is minimizing the regularization penalty terms. Considering cumulative foot pressure image may present different appearance, only optimizing the two terms is not enough to reflect the structure information. Hence we propose to let z contain the correlation with its K neighbor patches. Supposing z follows Gaussian distribution, we modified (2), and obtain a new optimization formulation: 

$$L=\min\frac{1}{2}\|x-Dz\|_{2}^{2}+\lambda\sum_{i}\|w_{i}z_{i}\|\tag{5}$$

Where wi is the Euclidean distance between i z and its nearest Gaussian distribution center. 

## 4.2 **Discriminative Hlsc**

Sparse coding, locality-constrained sparse coding, hierarchical locality-constrained sparse coding are all unsupervised feature selection methods. Previous studies show the effectiveness of combination of unsupervised method with discriminative model [23]. Inspired by them, we proposed fisher linear discriminative analysis model to extract the discriminative components after hierarchical linear-constrained sparse coding. 

Considering the representation z, which is the feature vectors obtained from hierarchical linear-constrained sparse coding, we also collect the corresponding label y. fisher linear discriminative analysis give a dimensionality reduced components z'. Based on the process, we can achieve both discriminative and approximated lowest-reconstruction-error feature representation z'. 

$$(2)$$

## 5. **Experimental Results**

In this section, we report results based on two proposed cumulative foot pressure dataset: barefoot dataset and shoes-invariant dataset. As far as we know, there are no previous public accessible dataset for cumulative foot pressure images. One contains all barefoot cumulative foot pressure images and its corresponding gender and identity label. It is collected from 88 subjects, including 68 male and 20 female. Another sub dataset contains barefoot cumulative foot pressure images, wearing cloth shoes one, wearing sports shoes one and wearing leather shoes one. It is collected from 30 male subjects. These subjects came from different areas and they are constituted with different age groups from 22 to 50. Hence the experimental results are not limited to a specific group of people. 