
## 2.1 Qualitative O-Point Relations And Reasoning

In a coarse representation a single o-point induces the sectors depicted in figure 1.

"front", "back", "left", and "right" are linear sectors. "left-front", "right-front", "leftback", and "right-back" are quadrants. The position of the point itself is denoted as
"same". This qualitative granularity corresponds to Freksa's double cross calculus
[5, 25].

A qualitative spatial relative direction relation between two o-points is represented by two pieces of information:
- the sector (seen from the first o-point) in which the second o-point lies (this determines the lower part of the relation symbol), and
- the sector (seen from the second o-point) in which the first o-point lies (this determines the upper part of the relation symbol).

For the general case of the two points having different positions we use the following relation symbols:
front front, lf front, left front, lb front, back front, rb front, right front, rf front, front lf ,
lf lf, *. . .*,
rf rf.

Altogether we obtain 8 × 8 base relations for the two points having different positions.

Then the configuration shown in figure 2 is expressed with the relation A lf rf B. If both points share the same position, the lower relation symbol part is the word "same" and the upper part denotes the direction of the second o-point with respect to the first one as shown in figure 3.

![0_image_0.png](0_image_0.png)

Figure 2: Qualitative spatial relation between two oriented points at different positions.

The qualitative spatial relation depicted here is A lf rf B.

Altogether we obtain 72 different atomic relations (eight times eight general relations plus eight with the o-points at the same position). These relations are jointly exhaustive and pairwise disjoint (JEPD). The relation front same is the identity relation.

In order to apply constraint-based reasoning to a set of qualitative spatial relations, the relations ideally should form a relation algebra [10] or a non-associative algebra
[14, 11]. Such an algebra can be generated from a jointly exhaustive and pairwise disjoint set of base relations by forming the power set, giving the general relations, with bottom, top, intersection, union and complement of relations defined in the settheoretic way. Moreover, an identity base relation and a converse operation (^) on base relations must be provided; the latter naturally extends to general relations. Finally,