
## 2.2 Finer Grained O-Point Calculi

The design principle for the coarse *OPRA* calculus described above can be generalized to calculi *OPRA*m with arbitrary m ∈ N. Then an angular resolution of 2π 2m is used for the representation (a similar scheme for absolute direction instead of relative direction was designed by Renz and Mitra [23]). The granularity used for the introduction of the *OPRA* calculus in the previous section is m = 2, the corresponding OPRA version is then called *OPRA*2.

To formally specify the o-point relations we use two-dimensional continuous space, in particular R
2. Every o-point S on the plane is an ordered pair of a point pS represented by its Cartesian coordinates x and y, with *x, y* ∈ R and an orientation φS.

S = (pS, φS), pS = ((pS)x,(pS)y)
We distinguish the relative locations and directions of the two o-points A and B
expressed by a calculus *OPRA*m according to the following scheme. For A, B with pA 6= pB, we define ϕAB := *atan2* ((pB)y − (pA)y,(pB)x − (pA)x)
where atan2 (*y, x*) is the angle between the positive x-axis and the point (*x, y*), normalised to the interval ] − *π, π*]. By the properties of *atan2* , we get ϕBA = ϕAB + π modulo normalization to ] − *π, π*]. In the sequel, we will normalize all angles to this interval, reflecting the cyclic order of the directions. Hence, e.g. −π stands for π. Moreover, in case that *α > β*, the open interval ]*α, β*[ will stand for ]α, π] ∪ ] − *π, β*[.

For example, ]
π 2
, −
π 2
[ stands for ]
π 2
, π] ∪ ] − π, −
π 2
[.

Similarly, we enumerate directions by using the 4m elements of the cyclic group Z4m. Each element of the cyclic group is interpreted as a range of angles as follows:

$$[i]_{m}={\left\{\begin{array}{l l}{\left]2\pi{\frac{i-1}{4m}},2\pi{\frac{i+1}{4m}}\right[},}&{{\mathrm{if~}}i{\mathrm{~is~odd}}}\\ {\left\{2\pi{\frac{i}{4m}}\right\},}&{{\mathrm{if~}}i{\mathrm{~is~even}}}\end{array}\right.}$$

Conversely, for each angle α, there is a unique element i ∈ Z4m with α ∈ [i]m.

If pA 6= pB, the relation A m∠
j i B (i, j ∈ Z4m) reads like this: Given a granularity m, the relative position of B with respect to A is described by i and the relative position of A with respect to B is described by j. Formally, it represents the set of configurations satisfying ϕAB − φA ∈ [i]m and ϕBA − φB ∈ [j]m.

Figure 4 shows the resulting granularity for m = 4. Using this notation, a simple manipulation of the parameters yields the converse operation (m∠
i j
)^ = m∠
j i.

If pA = pB, the relation A m∠i B represents the set of configurations satisfying