[15], where the model is called the *cardinal direction calculus* (CDC). When representing the direction of the primary object to a reference object, the CDC approximates the reference object by a box, while leaving the primary object unaltered. Therefore, the exact geometry of the primary object is used to a certain extent in the representation of the direction. This makes the CDC very expressive. As a matter of fact, this calculus has 218 basic relations, each of which represents some *definite* directional information between objects. Non-basic relations, which are unions of basic relations, represent *indefinite* directional information between objects.

The CDC as a qualitative calculus is unlike other well-known qualitative calculi such as the Interval Algebra (IA) [1] and RCC8 [12]. The identity relation is not a CDC relation, but is contained in a unique basic CDC relation. The CDC is closed under neither converse nor composition. This means, the converse of a basic CDC relation (or the composition of two basic CDC relations) may be not a CDC relation, i.e. it may be not the union of some basic CDC relations [5, 3, 15, 10].

Consistency checking is the central reasoning problem in the CDC (and any other qualitative calculus). Given a *complete* network of CDC constraints

$${\mathcal{N}}=\{v_{i}\delta_{i j}v_{j}\}_{i,j=1}^{n}{\mathrm{~(each~}}\delta_{i j}{\mathrm{~is~a~CDC~relation)~}}$$
$$(1)$$
i,j=1 (each δij is a CDC relation) (1)
over n spatial variables v1, · · · , vn, we say N is *consistent* (or *satisfiable*) if there exist n *connected* plane regions a1, · · · , an such that (ai, aj ) is an instance of δij for any 1 ≤
i, j ≤ n. If the relations δij are all taken from a subclass S of the CDC, we write **RSAT**(S)
for the consistency decision problem restricted to S. In particular, **RSAT**(CDC) denotes the consistency decision problem in the CDC.

To solve the general consistency problem of a qualitative calculus, an often used approach is to devise local consistency algorithms to completely solve the decision problem over a subclass S of the calculus, which contains all basic relation, and then use backtracking method to solve the whole decision problem. We call a complete network N of basic constraints k-*consistent* if all subnetworks of N that involve k variables are consistent.1 In particular, for a complete network of basic constraints, 3-consistency is equivalent to path-consistency (cf. [9] for detailed discussion).

For the IA and RCC8, it is known that path-consistency decides the consistency of complete basic networks. Examples (cf. [15, Example 9] and [10, Example 4]) show that, however, local k-consistency, in particular path-consistency, is insufficient to determine the consistency of basic CDC constraints. This makes reasoning with the CDC a very difficult problem. For a long time, it is even not known if consistency checking in the