This suggests that the O(n 5) algorithm devised in [16] for determining the consistency of basic CDCd networks is incomplete.

Suppose N is a possibly incomplete basic CDCd network. Algorithm CONSISTENCY
[16] first transforms constraints in N into a network O of Point Algebra (PA) constraints
(which may also be incomplete). It then calls the CSPAN algorithm of van Beek [17]
to compute a solution of O and transforms the solution of O into a maximal solution
(cf. [16] for the definition). The algorithm then returns 'consistency' if this particular maximal solution satisfies the NTB property, and returns 'inconsistency' otherwise.

Because the network of constraints may be incomplete, the PA network O may have exponentially many different (maximal) solutions.2 As a polynomial algorithm, Algorithm CSPAN returns only one solution of O. It has been proved [16, Theorem 3] that O
is consistent if and only if it has a maximal solution which satisfies the NTB property. It is very likely that *some* maximal solutions of O satisfy the NTB property, while others do not. So if we want to assure O is inconsistent, we need to try all different maximal solutions of O, which may take exponential time. Algorithm CONSISTENCY, however, checks this for only one maximal solution (constructed on the result of Algorithm CSPAN). This explains why it is an incomplete algorithm for checking the consistency of basic CDCd networks.

Take the inconsistency basic network in [16, Example 13] as an example. This network is defined as

$${\mathcal{N}}=\{x\;N\!:\!E\!:\!O\;y,x\;O\!:\!S\!:\!W\;z,y\;S W\;z\}.$$
$\left(\mathcal{M}\right)$
N = {x N :E :O y, x O:S :*W z, y SW z*}. (48)
The inconsistency of N is detected by Algorithm CSPAN. In fact, the algorithm first transform N into a set O of PA constraints, and then CSPAN returns a solution of O, and then uses this solution to compute a maximal solution of O. Write m for this maximal solution. The algorithm then returns 'inconsistency' after showing that m does not satisfy the NTB property. So far so good. Let N 0 be the network obtained by removing the third constraint *y SW z* from N . It is easy to see that N 0is consistent. For this network, a subset O0 of O is computed, and it is likely that the algorithm also takes m as a maximal solution of O0. If this is the case, the algorithm will return 'inconsistency' for N 0 because m does not satisfy the NTB property. This is, however, incorrect.