Clustering is a method of unsupervised learning, and a common technique for statistical data analysis used in many fields, including machine learning, data mining, pattern recognition, image analysis and bioinformatics. 

## 3.1 Classification By Decision Tree

Data mining techniques are useful for predicting and understanding the frequent signs and symptoms of behavior of LD. There are different types of learning disabilities. If we study the signs and symptoms (attributes) of LD we can easily predict which attribute is from the data sets more related to learning disability. The first task to handle learning disability is to construct a database consisting of the signs, characteristics and level of difficulties faced by those children. Data mining can be used as a tool for analyzing complex decision tables associated with the learning disabilities. Our goal is to provide concise and accurate set of diagnostic attributes, which can be implemented in a user friendly and automated fashion. After identifying the dependencies between these diagnostic attributes, rules are generated and these rules are then be used to predict learning disability. In this paper, we are using a checklist containing the same 16 most frequent signs & symptoms (attributes) generally used for the assessment of LD [13] to investigate the presence of learning disability. This checklist is a series of questions that are general indicators of learning disabilities. It is not a screening activity or an assessment, but a checklist to focus our understanding of learning disability. The list of 16 attributes used by us in LD prediction is shown in Table 1 below. 

| Table 1. List of Attributes   |           |                                          |
|-------------------------------|-----------|------------------------------------------|
| Sl.                           | Attribute | Signs & Symptoms of LD                   |
| No.  1                        | DR        | Difficulty with Reading                  |
| 2                             | DS        | Difficulty with Spelling                 |
| 3                             | DH        | Difficulty with Handwriting              |
| 4                             | DWE       | Difficulty with Written Expression       |
| 5                             | DBA       | Difficulty with Basic Arithmetic skills  |
| 6                             | DHA       | Difficulty with Higher Arithmetic skills |
| 7                             | DA        | Difficulty with Attention                |
| 8                             | ED        | Easily Distracted                        |
| 9                             | DM        | Difficulty with Memory                   |
| 10                            | LM        | Lack of Motivation                       |
| 11                            | DSS       | Difficulty with Study Skills             |
| 12                            | DNS       | Does Not like School                     |
| 13                            | DLL       | Difficulty Learning a Language           |
| 14                            | DLS       | Difficulty Learning a Subject            |
| 15                            | STL       | Slow To Learn                            |
| 16                            | RG        | Repeated a Grade                         |

Based on the information obtained from the checklist, a data set is generated. This is set is in the form of an information system containing cases, attributes and class. A complete information system expresses all the knowledge available about objects being studied. Decision tree induction is the learning of decisions from class labeled training tuples. Given a data set D = {t1, t2**,…...….,** tn} where ti = <ti1,….., tih**>. In our study, each tuple is represented by 16 attributes and the class is** 
LD. Then, Decision or Classification Tree is a tree associated with D such that each internal node is labeled with attributes DR, DS, DH, DWE, etc. Each arc is labeled with predicate, which can be applied to the attribute at the parent node. Each leaf node is labeled with a class LD. The basic steps in the decision tree are building the tree by using the training data sets and applying the tree