International Journal of Web & Semantic Technology (IJWest) Vol.1, Num.4, October 2010

# Detecting Ontological Conflicts In Protocols Between Semantic Web Services

Priyankar Ghosh and Pallab Dasgupta Department of Computer Science and Engineering, Indian Institute of Technology Kharagpur, India
{priyankar, pallab}@cse.iitkgp.ernet.in Abstract. **The task of verifying the compatibility between interacting web services has traditionally been limited to checking the compatibility of the interaction protocol in terms of message**
sequences and the type of data being exchanged. Since web services are developed largely in an uncoordinated way, different services often use independently developed ontologies for the same domain instead of adhering to a single ontology as standard. **In this work we investigate the**
approaches that can be taken by the server to verify the possibility to reach a state with semantically inconsistent results during the execution of a protocol with a client, if the client ontology is published. Often database is used to store the actual data **along with the ontologies instead**
of storing the actual data as a part of the ontology description. It is important to observe that at the current state of the database the semantic conflict state may not be reached even if the verification done by the server indicates the possibility of **reaching a conflict state. A relational** algebra based decision procedure is also developed to incorporate the current state of the client and the server databases in the overall verification procedure.

## 1 Introduction

Ontology is regarded as a formal specification of a (usually hierarchical) set of concepts and the relations between them. The need for developing intelligent web services that **can automatically interact with** other web services has been one of the primary forces behind recent research towards standardization of ontologies of specific domains of interest [1, 2, 3, 4, 5]. For example, **if several online book stores follow** the same ontology for the book **domain, then it facilitates an intelligent web service to automatically**
search these book stores to find books in a particular category.

In the context of next generation of web, it is envisaged that intelligent agents will find, combine, and act upon information on the web, thereby perform the routine **day-to-day jobs independently.** The protocols that will be used by such intelligent agents to communicate with the semantic web services, will play an extremely important role towards materializing the next generation of web. The protocol may contain branches which are decisions made on the basis of the previous information exchange. Along with defining the information exchange between the client and server in the form of a set query-answer, independent actions will be described as a part **of the protocol. The action may be** automatically executed or may need manual intervention for completion, but the information required to initiate the action is provided by answer of the previous queries. We present an example of such protocol in Section 2.

When two communicating web services use ontologies, with respect to semantic conflict the following scenarios are possible. Scenario-1 : **If the web services choose to use the same ontology, there will be no semantic conflict.**
In this paper we observe that the requirement that the ontologies **used by communicating web** services must match is a very strong requirement which is often not **needed in practice.**
DOI : 10.5121/ijwest.2010.1403 28