Scenario-2 : **If two communicating web services use different ontologies, then they may potentially**
reach a state where there is a semantic conflict/mismatch arising out of the differences between their ontologies. For example, suppose the ontologies of web service A and web service B **recognize**
the class vehicle and its sub-classes, namely, car, truck and bike. The ontology of A defines **color** as an attribute of class vehicle, where as the ontology of B defines color **as an attribute of the** sub-classes car and bike only. Now suppose A **wants to follow the following protocol with** B:
Step-1: Ask B **for the registration number of a vehicle which is owned by a given person.**
Step-2: If B finds the registration number, then ask B **for the color of the vehicle.**
Several executions of this protocol are possible for different valuations of the data exchanged by the protocol. Semantic conflicts arising out of the differences in ontologies may occur in some of these cases, but not always. For example:
- If B **does not find the registration number, then Step-2 is not executed and there is no semantic**
conflict.

- If B **finds the registration number and the vehicle happens to be a truck, then Step-2 of the**
protocol will lead to a semantic conflict, since in B's ontology, the color **attribute is not defined**
for trucks.

- If B finds the registration number and the vehicle happens to be a car or **a bike, then Step-2**
will not lead to a semantic conflict, since in B's ontology, the color **attribute is defined for cars**
and bikes.

If the ontology of A and the protocol is made available to B, then B **can formally verify whether** any execution of the protocol may lead to a semantic conflict and warn A **accordingly before the**
actual execution of the protocol begins. There has been considerable research in the recent past on matching ontologies and finding out semantic conflicts/mismatches among two ontologies [6, 7, 8]. In many cases, two web services may have conflicting ontologies, but the protocol between them may avoid the conflict scenarios. Consider the scenario where the direction of query-answer is reversed, that is the same sequence of queries are made by A and answered by B. Also A **makes the query about the color of vehicle only**
if the vehicle is not a truck. In this case the conflict will not be sensitized by the protocol. In other words, two agents may not agree on all concepts in their universe, **but may still be able to support** certain protocols as long as they avoid the contentious issues - a fact which is often ignored in world politics! Therefore an approach which rules out communication **between two services on the** grounds that their ontologies do not match is too conservative in practice. Since the standardization of ontologies and their acceptance in industrial practice seems to be a distant possibility, we believe that the verification problem presented in this paper and its solution **is very relevant at present.**
Scenario-3 : **The ontologies can be visualized as a combination of meta-data and a set of instances.**
Classes, relations and data-types form the meta-data part of the ontology, whereas the individuals and the valuations of the attributes are the actual data. It is often the case that the actual data is stored in a database, and ontologies are used as a wrapper on top **of the databases. Therefore** the state of the database has to be incorporated, while the server checks whether the protocol can possibly reach conflict state. Since the protocol between the client and the server typically have branches and the decision for making the next query is dependent on the answer of the current query, the conflict that is present at the ontology level may not be **sensitized due to the the answers** generated from the back-end database. We present a relation algebra based decision procedure to check whether the conflict, that are present in the ontology level, **are actually present with respect** to the current state of the back-end database.

Scenario-4 : **It is important to observe that the protocol has different runs depending on the instantiation of the variables that are used in the protocol. Since the conflict may not be sensitized in**
a particular run of the protocol, the server may choose to start the protocol and check the possibility to get into a conflict after every information exchange. Depending on how the conversation 29