International Journal of Web & Semantic Technology (IJWest) Vol.1, Num.4, October 2010 progresses the server may either continue to run protocol, or may terminate the conversation when it finds that the conflict is inevitable.

A preliminary version of this work is published in [9]. In that version we presented the verification algorithm for Scenario-2. In this paper we include the algorithms for **Scenario-3, i.e. the verification of** the spuriousness of an ontological conflict with respect to the current state of the back-end database.

We also show that the same algorithm can be used by the server for Scenario-4. The paper is organized as follows. The syntax for describing a protocol is described in Section 2. In Section 3 we present a graph based model for representing the ontologies. The proposed formal method for detecting semantic conflicts at the ontology level is presented in Section 4. The notion of ontology with database and query answering with the back-end database and the algorithm to verify the conflicts at the ontology level in the presence of the database are presented in Section 5. Related **works are briefly discussed in Section 6.** Finally we present the conclusion in Section 7.

## 2 Protocol And Conflict

In this section we present a formalism similar to SQL for the specification of the protocol. It may be noted that other formalisms can also be used to specify a protocol as long as the formalism has expressive power similar to the formalism used in this paper. We present two example protocols and also describe the notion of the conflict that we have addressed in this paper.

## 2.1 Formal Description Of The Protocol

Typically, a protocol consists of a sequence of queries and answers. The query specifies a set of variables through "Get" keyword and specifies a set of classes using "from" keyword. The valuations corresponding to the variable set are generated from those classes. Also an optional "where" **keyword is used to**
specify the conditions on the variables. The answer of a query is a tuple of valuations corresponding to the variable set specified in the query. The branching is specified using "if-else" **statements.**

## 2.2 Example Of Protocol

[Protocol - 1 :] Consider the protocol shown in Figure 1. The protocol depicts a conversation between a client and a server over the publication domain. The query of **the client is about the author of**
some specific manual. Then the client makes a query to retrieve a book by the author of that manual. According to the ontology of the client, 'Proceedings' is a subclass of 'Book' **and the client makes the**
next query to retrieve the proceedings by the same author. If the server does not recognize 'Proceedings' as a sub class of 'Book', the query can not be answered by the server due to the mismatch **in the**
ontologies.

[Protocol - 2 :] **In Figure 2 we present another protocol that exchanges information about the automobile domain. The client makes a query to retrieve a brand which has sold more than a specific**
number of vehicles in a particular year. Then next query is made in the **context of the previous query** to check whether that brand manufacture 'Red Trucks'**. According to the ontology of the client the** color is a property of the vehicle class and therefore all subclasses **of vehicle class will have the color**
attribute. However if the server recognizes 'color' **as an attribute of some of the sub-classes(suppose** 'car' and 'two-wheeler') instead of as an attribute of the class 'Vehicle' **itself, the query can not be** answered by the server due to the mismatch in the ontology.

30