nonlinear due to the memory paging. Finally, at the sequence length of about 4.5 million the EMP becomes faster than FB.

One possibility for FB memory reduction is recomputation of transition matrices which is done in the Case II.

Case II: This corresponds to middle length sequences, between 4 and 5 million. At this case the sequence and all intermediate results are stored in RAM, but the transition matrices are recomputed every time they are used. Similar to the Case I, as the sequence becomes longer, the memory required for storing the forward vectors increases and, for sequences longer then 5 million, FB algorithm becomes slower than the EMP (see Figure 3b).

Case III: This corresponds to long sequences between 5 and 25 million. As in Case II, transition matrices are recomputed and all another intermediate results are stored in RAM, but the sequence cannot fit in RAM and needs to be stored on the secondary memory. In the FB the sequences have to be read twice from secondary memory, once in the forward and once in the backward phase. On the other hand, the EMP uses a single forward pass and reads the sequence only once, which makes it faster than the FB (Figure 3c).

Case IV: This corresponds to very long sequences loger than 25 million. In this case, similar to the Case III, the sequence is stored on the secondary memory. To avoid the FB performance decreasing due to a large number of intermediate variables stored in RAM, the portion of variables is stored on the secondary memory, which keeps the RAM usage constant, no longer dependent on the sequence length (Figure 3c). This increases the number of accessions to the secondary memory, which further decreases FB performances in comparison to Case III. On the other hand, the EMP does not need to store additional data on the secondary memory and has the same time growth as in Case III, while using a small constant memory.

The previous results can vary with different operating systems and used hardware. Nevertheless, the access to secondary memory is very expensive operation and the algorithm with a low memory complexity has the advantage, when all data cannot fit in RAM, since the secondary memory accesses can be avoided.

## 6. Conclusion

In this paper, we have developed a numerically stable algorithm for the computation of the linear-chain CRF gradient. As opposed to the standard way of finding a CRF gradient by use of the forward-backward algorithm, the calculation by the proposed algorithm requires only the forward pass and can be realized with the memory independent of the observation sequence length. This makes the algorithm useful in the long sequence labeling tasks found in computer security [18], [28], bioinformatics [16],[19], and robot navigation systems [15].

The proposed algorithm operates as a forward algorithm over the log-domain expectation semiring, which can be seen as a modification of the expectation semiring used in the automata theory and probabilistic context free grammars [32], [33]. As mentioned in the paper, the use of the expectation semiring leads to numerically unstable algorithms and its log-domain counterpart can also be applied to numerically stable solutions of problems considered in [32], [33].

## 7. References References

[1] S.M. Aji and R.J. McEliece. The generalized distributive law. *Information* Theory, IEEE Transactions on, vol. 46(2), pages 325 –343, 2000.

[2] L. Bahl, J. Cocke, F. Jelinek, and J. Raviv. Optimal decoding of linear codes for minimizing symbol error rate (corresp.). Information Theory, IEEE Transactions on, vol. 20(2), pages 284 - 287, 1974.

[3] L. Baum. An inequality and associated maximization technique in statistical estimation for probabilistic functions of Markov processes. *Inequalities*, vol. 3, pages 1–8, 1972.

[4] Leonard E. Baum and Ted Petrie. Statistical inference for probabilistic functions of finite state markov chains. *The Annals of Mathematical* Statistics, vol. 37(6), pages 1554–1563, 1966.

[5] R. Chang and J. Hancock. On receiver structures for channels having memory. *Information Theory, IEEE Transactions on*, vol. 12(4), pages 463 - 468, 1966.

[6] Alexander Churbanov and Stephen Winters-Hilt. Implementing em and viterbi algorithms for hidden markov model in linear memory. BMC Bioinformatics, vol. 9(224), 2008.

[7] Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, and Clifford Stein. *Introduction to Algorithms*. McGraw-Hill Science / Engineering /
Math, 2nd edition, 2003.

[8] Cortes C., Mohri M., Rastogi A., and Riley M., On the computation of the relative entropy of probabilistic automata, *International Journal of* Foundations of Computer Science, vol. 19, pages 219-242, 2007.

[9] Robert G. Cowell, Philip A. Dawid, Steffen L. Lauritzen, and David J.

Spiegelhalter. Probabilistic Networks and Expert Systems (Information Science and Statistics). Springer, New York, 2003.

[10] Eisner J., Parameter estimation for probabilistic finite-state transducers.

in *Proceedings of the 40th Annual Meeting of the Association for Computational Linguistics*, pages 1–8, 2002.

[11] J. Alicia Grice, Richard Hughey, and Don Speck. Reduced space sequence alignment. *Computer Applications in the Biosciences*, vol. 13(1),
pages 45–53, 1997.

[12] Rahul Gupta. Conditional random fields, 2006. Technique Report, IIT
Bombay.

[13] Velimir M. Ili´c, Miomir S. Stankovi´c, and Branimir T. Todorovi´c. Entropy message passing algorithm. *IEEE Transactions on Information Theory*, vol 57(1), pages 375–380, 2011.

[14] Wael Khreich, Eric Granger, Ali Miri, and Robert Sabourin. On the memory complexity of the forward-backward algorithm. Pattern Recognition Letters, vol 31(2), pages 91–99, 2010.

[15] Sven Koenig and Reid G. Simmons. Unsupervised learning of probabilistic models for robot navigation. In *in Proceedings of the IEEE International Conference on Robotics and Automation*, pages 2301–2308, 1996.

[16] Anders Krogh, Michael Brown, I. Saira Mian, Kimmen Sjlander, and David Haussler. Hidden markov models in computational biology: applications to protein modeling. *Journal of Molecular Biology*, vol. 235, pages 1501–1531, 1994.

[17] John Lafferty, Andrew Mccallum, and Fernando Pereira. Conditional random fields: Probabilistic models for segmenting and labeling sequence data. In *Proc. 18th International Conf. on Machine Learning*, pages 282–
289, 2001.

[18] Terran D. Lane. Machine learning techniques for the computer security domain of anomaly detection, PhD thesis, Purdue University, USA, 2000.

[19] Irmtraud M. Meyer and Richard Durbin. Gene structure conservation aids similarity based gene prediction. *Nucleic acids research*, vol. 32(2), pages 776–783, 2004.

[20] I. Mikl´os and I. M. Meyer. A linear memory algorithm for baum-welch training. *BMC bioinformatics*, vol. 6, 2005.

[21] Fei Sha and Fernando Pereira. Shallow parsing with conditional random fields. *In NAACL '03*, vol.1, pages 213–220, 2003.

10