Since only the forward pass is needed, the EMP can be implemented with the memory complexity being independent of the sequence length, having the advantage over the FB when long sequences are used.

The paper is organized as follows: In section II we explain the FB algorithm which operates over a commutative semiring.

In section III we introduce the problem of efficient computation of a linear-chain CRF gradient and review the standard method based on the FB algorithm. The algorithms based on the EMP
are presented in section IV, where the complexity analysis is given. Finally, the experimental results are presented in section V where two methods are compared and the advantage of the EMP is discussed.

## 2. The Forward-Backward Algorithm Over A Commutative Semiring

Definition 1. A commutative semiring *is a tuple* (K, ⊕, ⊗, 0, 1) where K is the set with operations ⊕ and ⊗ such that both ⊕ and
⊗ *are commutative and associative and have identity elements* in K (0 and 1 respectively), and ⊗ *is distributive over* ⊕.

Let (K, ⊕, ⊗, 0, 1) be a commutative semiring and let y =
{y0, . . . , yT } be a set of variables taking values from the set Y of cardinality N. We define the *local kernel* functions ut∶ Y2 → K
for t = 1, . . . , T, and the *global kernel* function u ∶ YT+1 → K,
assuming that the following factorization holds

$u(y)=\sum_{i=1}^{T}u_{i}(y_{i-1},y_{i})$  $u(y)=\sum_{i=1}^{T}u_{i}(y_{i-1},y_{i})$  $u(y)=\sum_{i=1}^{T}u_{i}(y_{i-1},y_{i})$ 
for all $\mathbf{y}=(y_{0},\ldots,y_{T})\in\mathcal{Y}^{T+1}$.  The $F$B algorithm [26], [27] solves two problems.  
1. The *marginalization problem:* Computes the sum
$$v_{t}(y_{t},y_{y+1})=\bigoplus_{y_{\{k-1,k\}^{c}}}u(y)=\bigoplus_{y_{\{k-1,k\}^{c}}}^{T}u_{i}(y_{i-1},y_{i}),\tag{2}$$
2. The *normalization problem:* Computes the sum

$$Z=\bigoplus_{y}u(y)=\bigoplus_{i=1}^{T}u_{i}(y_{i-1},y_{i}).$$
ui(yi−1, yi). (3)
The FB recursively computes the *forward vector*

$$\alpha_{i}(y_{i})=\bigoplus_{y_{0i-1}}^{i}\bigotimes u_{t}(y_{t-1},y_{t}),$$

which is initialized to α0(y0) = 1, (5)
and recursively computed using

$$\alpha_{i}(y_{i})=\bigoplus_{y_{i-1}}u_{i-1}(y_{i-1},y_{i})\otimes\alpha_{i-1}(y_{i-1})$$

and the backward vector

$$\beta_{i}(y_{i})=\bigoplus_{s_{i+1:T}}\bigotimes_{t=i+1}^{T}u_{t}(y_{t-1},y_{t}),$$

which is recursively computed using

$$\beta_{i}(y_{i})=\bigoplus_{y_{i+1}}u_{i+1}(y_{i},y_{i+1})\otimes\beta_{i+1}(y_{i+1})\tag{8}$$

and initialized to
$$\beta_{T}(y_{T})=1.$$
Once the forward αk−1 and backward βk vectors are computed,
we can solve the marginalization problem by use of the formula
$$\bigoplus_{\{k-1,k\}^{c}}\bigotimes_{i=1}^{T}u_{i}(y_{i-1},y_{i})=\alpha_{k-1}(y_{k-1})\otimes u_{k}(y_{k-1},y_{k})\otimes\beta_{k}(y_{k})\tag{10}$$
The normalization problem can be solved with the forward pass only according to

$$\bigoplus_{i=1}^{T}u_{i}(y_{i-1},y_{i})=\bigoplus_{y_{T}}\alpha_{T}(y_{T}).\tag{11}$$

## 3. Linear-Chain Crf Training Using The Forward Backward Algorithm

Linear-chain CRFs are discriminative probabilistic models over observation sequences x = (x1, . . . , xT ) and label sequences y = (y1, . . . , yT ), defined with conditional probability

$p(y|x;\theta)=\frac{1}{Z(x;\theta)}\prod_{i=1}^{T}\left(\theta,f(y_{i-1,y_{i},x,i})\right)$.  
⟨θ, f(yi−1,yi,x,i)⟩. (12)
$$(1)$$
The symbol ⟨⋅, ⋅⟩ denotes the scalar product between an Mdimensional parameter vector

$$(12)$$
$$\theta=\left[\theta_{1},\ldots,\theta_{M}\right]$$
$$(13)$$

θ = [θ1, . . . , θM] (13)
and the *feature vector* on position i f (yi−1, yi, x, i) = [ f1(yi−1, yi, x, i), . . . , fM(yi−1, yi, x, i)]. (14)
The normalization factor

$Z(x;\theta)=\sum_{i=1}^{T}\epsilon^{(\theta,f(y_{i-1,y_{i},x,i}))}$
$$(15)$$
$$(16)$$
$$({\mathfrak{I}})$$
$$\left(4\right)$$
is called the *partition function*.

The goal of the CRF training is to build up the model (12)
from the data set {(x
(d), y
(d)}
D
d=1
. The standard method is to maximize the log likelihood of (12):

$${\mathcal{L}}(\theta)=\sum_{d=1}^{D}\ln p(y^{(d)}|x^{(d)};\theta)$$
(d); θ) (16)
$${\mathrm{(5)}}$$
$$(6)$$

over the parameter vector θ for the chosen set of feature vectors f (yi−1, yi, x, i). The maximum can be found with several of the gradient methods [12], [17], [21], [23], [25], which requires the computation of the gradient ∇θL(θ). The gradient can be expressed, according to (12) and (16), as:

$$\nabla_{\theta}{\cal L}(\mathbf{\theta})=\sum_{d=1}^{D}\sum_{i=1}^{T^{(d)}}f(y_{i-1}^{(d)},y_{i}^{(d)},\mathbf{x}^{(d)},i)-\sum_{d=1}^{D}\frac{\nabla_{\theta}Z(\mathbf{x};\mathbf{\theta})}{Z(\mathbf{x};\mathbf{\theta})},\tag{17}$$
$$2$$
