Similarly to Lemma 1 and to expression (7), the backward vector in the log-domain sum-product semiring is the logarithm of the backward vector in sum-product semiring:

T ⊗t=i+1 e ⟨θ, f(yt−1,yt,x,t)⟩= βi(yi) = ⊕ yi+1∶T T ∏ t=i+1 e ⟨θ, f(yt−1,yt,x,t)⟩, (33) = ln ∑ yi+1∶T being initialized to βT (yT ) = 0, (34) and recursively computed using
$$\beta_{i}(y_{i})=\bigoplus_{y_{i+1}}{\big(}u_{i+1}(y_{i},y_{i+1})+\beta_{i+1}(y_{i+1}){\big)}.$$
If the log-domain addition is performed using the definition, a ⊕ b = ln(e a + e b), the numerical precision is being lost when computing e aand e b. But, as noted in ([23]), ⊕ can be computed as

$$a\oplus b=a+\ln\left(1+\mathbf{e}^{(b-a)}\right)=b+\ln\left(1+\mathbf{e}^{(a-b)}\right),$$
(a−b)), (36)
which can be much more numerically stable, particularly if we pick the version of the identity with the smaller exponent.

The logarithm of the normalization constant (21) is according to Lemma 1

$$\ln Z(\mathbf{x};\mathbf{\theta})=\ln\sum_{\mathbf{y}}\prod_{i=1}^{T}\mathbf{e}\left\langle\mathbf{\theta},f(y_{i-1,\,y_{i},\mathbf{x},i})\right\rangle=\bigoplus_{\mathbf{y}}\bigotimes_{i=1}^{T}u_{i}(y_{i-1},y_{i}),$$

(37)
and it can be computed using the solution of normalization problem in the log-domain sum-product semiring with forward algorithm according to (11)

$$\ln Z(\mathbf{x};\theta)=\bigoplus_{\mathbb{T}}\alpha_{T}(y_{T}).$$
αT (yT ). (38)
According to Lemma 1, the marginal values (23) in the logdomain sum-product semiring have the form

vk(yk−1, yk) = ln ∑ y{k−1,k}c T ∏ i=1 e ⟨θ, f(yi−1,yi,x,i)⟩= = ⊕ y{k−1,k}c T ⊗ i=1 ui(yi−1, yi). (39)
The marginal values can efficiently be computed according to the solution of the marginalization problems (10):
vk(yk−1, yk) = αk−1(yk−1) ⊗ uk(yk−1, yk) ⊗ βk(yk), (40)
where αk−1(yk−1) and βk(yk) are computed with the FB algorithm over the log-domain sum-product semiring, using equations (31)-(35). Then, by taking the logarithm of the m-th component in gradient expression (22), we get ln∇θm Z(x; θ) =

$\begin{array}{l}\includegraphics[height=142.26375pt]{Fig1}\end{array}$
for m = 1, . . . , M. Finally, the quotient between the partition function and its gradient can be computed according to

$\nabla_{\theta}Z(x;\theta)=\frac{\ln\nabla_{\theta}Z(x;\theta)-\ln Z(x;\theta)}{Z(x;\theta)}$.  
$$(42)$$
$$(41)$$
4

$$(33)$$

## Algorithm 1: Log-Domain Fb Algorithm

$$(34)$$
$$(35)$$
input : x, θ, f (yk−1, yk, x, k); yk−1, yk ∈ Y, k = 1, . . . , T;
output: ∇θZ(x; θ)/Z(x; θ);
/* Matrices initialization */
  **1 for $k\gets1$ to $T$ do**  **2**: **foreach $y_{k-1}$ in $\mathcal{Y}$ do**  **3**: **foreach $y_{k}$ in $\mathcal{Y}$ do**  **4**: $u_{k}(y_{k-1},y_{k})=\sum\limits_{m\in\mathcal{A}_{k}(y_{k-1},y_{k})}\theta_{m}\cdot f_{m}(y_{k-1},y_{k},\boldsymbol{x},k)$
$$/*{\mathrm{~Forward~phase~}}*/$$
5 foreach y0 in Y do 6 α0(y0) ← 0; 7 for k ← 1 to T do 8 foreach yk in Y do 9 αk(yk) ← ⊕yk−1(uk(yk−1, yk) + αk−1(yk−1)) /* Backward phase */
$$(36)^{\frac{1}{2}}$$
$$\mathbf{v}_{i}),$$
$$\begin{array}{r l}{{}}&{{}}\\ {{}}&{{}}\\ {{}}&{{}}\\ {{}}&{{}}\end{array}$$
12 for k ← T − 1 to 0 do 13 foreach yk in Y do 14 βk(yk) ← ⊕yk+1(uk+1(yk, yk+1) + βk+1(yk+1));
/* Termination */

$$(38)$$
15 ln Z(x; θ) = ⊕yT αT (yT ) 16 for k ← 1 to T do 17 foreach yk−1 in Y do 18 foreach yk in Y do 19 v = αk−1(yk−1) + uk(yk−1, yk) + βk(yk) 20 foreach m in Ak(yk−1, yk) do 21 ln f ← ln fm(yk−1, yk, x, k); 22 ln∇mZ ← ln∇mZ ⊕ (v + ln f ) 23 for m ← 1 to M do 24 ∇θm Z(x; θ)/Z(x; θ) ← e ln ∇mZ−ln Z
$$(39)$$
$$\partial_{k}(v_{k}),$$

3.3. Time and Memory Complexity The time and memory complexity of the algorithm for the computation of the partition function and its derivatives by the FB algorithm is given in Table 1. The time complexity is defined as the number of operations required for the execution of the algorithm for a given pseudo code. In our analysis we consider real operations (addition and multiplication), log-domain